/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.config;

import java.util.List;
import jp.ecuacion.splib.web.config.AuthorizationBean;
import org.springframework.boot.autoconfigure.security.servlet.PathRequest;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public abstract class SplibWebSecurityConfigForAdmin {
    protected abstract String getDefaultSuccessUrl();

    protected abstract String getUrlWithLoginNeededPageAccessed();

    protected abstract List<AuthorizationBean> getRoleInfo();

    protected abstract List<AuthorizationBean> getAuthorityInfo();

    protected String getAccessDeniedPage() {
        return "/public/adminLogin/page?accessDenied";
    }

    @Order(value=2)
    @Bean
    SecurityFilterChain filterChainForAdmin(HttpSecurity http, HandlerMappingIntrospector introspector) throws Exception {
        MvcRequestMatcher.Builder mvc = new MvcRequestMatcher.Builder(introspector);
        http.securityMatcher(new String[]{"/public/admin*/**", "/admin/**"});
        http.httpBasic(basic -> basic.disable());
        http.formLogin(login -> ((FormLoginConfigurer)((FormLoginConfigurer)login.loginPage(this.getUrlWithLoginNeededPageAccessed()).loginProcessingUrl("/public/adminLogin/action")).usernameParameter("adminLogin.username").passwordParameter("adminLogin.password").defaultSuccessUrl(this.getDefaultSuccessUrl(), true)).failureUrl("/public/adminLogin/page?error"));
        http.authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{PathRequest.toStaticResources().atCommonLocations()})).permitAll().requestMatchers(new RequestMatcher[]{mvc.pattern("/public/admin*/**")})).permitAll());
        if (this.getRoleInfo() != null) {
            for (AuthorizationBean bean : this.getRoleInfo()) {
                http.authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(bean.getRequestMatchers())).hasAnyRole(bean.getRoleOrAuthorities()));
            }
        }
        if (this.getAuthorityInfo() != null) {
            for (AuthorizationBean bean : this.getAuthorityInfo()) {
                http.authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(bean.getRequestMatchers())).hasAnyAuthority(bean.getRoleOrAuthorities()));
            }
        }
        http.logout(logout -> logout.logoutUrl("/public/adminLogout").logoutSuccessUrl("/public/adminLogin/page?logoutDone"));
        http.exceptionHandling(handling -> handling.accessDeniedPage(this.getAccessDeniedPage()));
        return (SecurityFilterChain)http.build();
    }
}

