package jp.ecuacion.splib.web.form.record;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.splib.web.bean.HtmlItem;
import jp.ecuacion.splib.web.bean.HtmlItemString;

public interface SearchRecordInterface {

  HtmlItem[] getHtmlItems();

  /** 項目ごとのsearch patternを返す。全項目を設定する必要はなく、検索で使用する項目のみで良い。 */
  default Map<String, StringMatchingConditionBean> getSearchPatterns() {
    Map<String, StringMatchingConditionBean> map = new HashMap<>();

    HtmlItem[] htmlItems = getHtmlItems();
    for (HtmlItem item : htmlItems) {
      if (item instanceof HtmlItemString
          && ((HtmlItemString) item).getStringSearchPatternEnum() != null) {
        HtmlItemString itemStr = (HtmlItemString) item;
        map.put(item.getItemName(), new StringMatchingConditionBean(
            itemStr.getStringSearchPatternEnum(), itemStr.isIgnoresCase()));
      }
    }

    return map;
  }

  default String getSearchPatternComment(Locale locale, String fieldName) {
    StringMatchingConditionBean bean = getSearchPatterns().get(fieldName);
    if (bean == null) {
      throw new RuntimeException("The searchPattern of field: " + fieldName
          + " not set in 'getSearchPatterns()' method in 'xxxSearchRecord'.");
    }

    String commentMessageId =
        new StringUtil().getLowerCamelFromSnake(bean.getStringSearchPatternEnum().toString());

    return PropertyFileUtil.getMsg(locale,
        "jp.ecuacion.splib.web.common.label.searchPattern." + commentMessageId + "Match");
  }
}
