/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.form;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import jp.ecuacion.splib.core.form.record.SplibRecord;
import jp.ecuacion.splib.web.advice.SplibExceptionHandler;
import jp.ecuacion.splib.web.form.record.RecordInterface;

public abstract class SplibGeneralForm {
    protected String dataKind;
    protected String confirmedWarnings;

    public String getDataKind() {
        return this.dataKind;
    }

    public void setDataKind(String dataKind) {
        this.dataKind = dataKind;
    }

    public SplibRecord get(String itemName) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        return (SplibRecord)this.getClass().getField(itemName).get(this);
    }

    public List<Field> getRootRecordFields() {
        Class<?> formCls = this.getClass();
        ArrayList<Field> checkList = new ArrayList<Field>();
        while (true) {
            Field[] fields;
            for (Field field : fields = formCls.getDeclaredFields()) {
                if (!SplibRecord.class.isAssignableFrom(field.getType())) continue;
                checkList.add(field);
            }
            if (formCls.getSuperclass() == SplibGeneralForm.class) {
                return checkList;
            }
            formCls = formCls.getSuperclass();
        }
    }

    @Deprecated
    public Field getRootRecordField() {
        List<Field> checkList = this.getRootRecordFields();
        if (checkList.size() == 0) {
            throw new RuntimeException("SplibRecord field not found in form: " + this.getClass().getName());
        }
        if (checkList.size() > 1) {
            throw new RuntimeException("Multiple SplibRecord field found in form: " + this.getClass().getName());
        }
        return checkList.get(0);
    }

    @Deprecated
    public Object getRootRecord() {
        return this.getRootRecord(this.getRootRecordField());
    }

    public Object getRootRecord(String recordName) {
        Field field = this.getRootRecordFields().stream().collect(Collectors.toMap(f -> f.getName(), f -> f)).get(recordName);
        return this.getRootRecord(field);
    }

    protected Object getRootRecord(Field rootRecordField) {
        rootRecordField.setAccessible(true);
        Object rootRecord = null;
        try {
            rootRecord = rootRecordField.get(this);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        return rootRecord;
    }

    public String getConfirmedWarnings() {
        return this.confirmedWarnings;
    }

    public boolean containsConfirmedWarning(String messageId) {
        return this.getConfirmedWarningMessageSet().size() > 0;
    }

    public Set<String> getConfirmedWarningMessageSet() {
        HashSet<String> rtnSet = new HashSet<String>();
        if (this.confirmedWarnings == null || this.confirmedWarnings.equals("")) {
            return rtnSet;
        }
        rtnSet.addAll(Arrays.asList(this.confirmedWarnings.split(",")));
        return rtnSet;
    }

    public void setConfirmedWarnings(String confirmedWarnings) {
        this.confirmedWarnings = confirmedWarnings;
    }

    public boolean hasNotEmptyError() {
        return this.validateNotEmpty().size() > 0;
    }

    public Set<SplibExceptionHandler.ValidationErrorInfoBean> validateNotEmpty() {
        return this.validateNotEmpty(Locale.getDefault());
    }

    public Set<SplibExceptionHandler.ValidationErrorInfoBean> validateNotEmpty(Locale locale) {
        String validationClass = "jakarta.validation.constraints.NotEmpty";
        HashSet<SplibExceptionHandler.ValidationErrorInfoBean> rtnSet = new HashSet<SplibExceptionHandler.ValidationErrorInfoBean>();
        List<Field> rootRecordFieldList = this.getRootRecordFields();
        for (Field rootRecordField : rootRecordFieldList) {
            String rootRecordFieldName = rootRecordField.getName();
            RecordInterface rootRecord = (RecordInterface)this.getRootRecord(rootRecordField);
            for (String notEmptyField : rootRecord.getNotEmptyFields()) {
                Object value = ((SplibRecord)rootRecord).getValue(notEmptyField);
                if (value != null && (!(value instanceof String) || !((String)value).equals(""))) continue;
                rtnSet.add(new SplibExceptionHandler.ValidationErrorInfoBean(ResourceBundle.getBundle("ValidationMessages", locale).getString("jakarta.validation.constraints.NotEmpty.message"), rootRecordFieldName + "." + notEmptyField, "jakarta.validation.constraints.NotEmpty"));
            }
        }
        return rtnSet;
    }
}

