package jp.ecuacion.splib.web.bean;

import java.util.HashMap;
import java.util.Map;
import org.springframework.ui.Model;

/** modelAttribute. */
public class SplibModelAttributes extends HashMap<String, Object> {

  private static final long serialVersionUID = 1L;
  
  // optionalだがlibrary側で対応が入っているものはあらかじめ本classないで管理しておく

  private boolean bsBgGradient = true;
  
  /** 
   * 基本はlight(default) / dark の2種類しか設定しないと思われるが、
   * カラーモードを追加することもbootstrapとしては可能なので、内部的にはカラーモード名を持つ形とする。
   * 通常使うものでもないのでdefaultでlightとしておく。
   */
  private boolean bsDarkMode = false;

  /** 
   * library側で対応は入っていないがapp共通で登録したいmodelAttributeはここに登録。
   * SystemCommonControllerに@ModelAttributeで登録してもいいのだが、library側で対応している項目はここに定義しているので
   * それ以外も併せて本クラスで一限管理することとする。
   */
  private Map<String, Object> appCommonModelAttributeMap;
  

  public Map<String, Object> getAppCommonModelAttributeMap() {
    return appCommonModelAttributeMap;
  }

  /** 追加は、mapをgetするのではなく、わかりやすくkey, valueを引数に渡す形で登録。 */
  public void addAppCommonModelAttribute(String key, Object value) {
    this.appCommonModelAttributeMap.put(key, value);
  }

  public boolean getBsBgGradient() {
    return bsBgGradient;
  }

  public void setBsBgGradient(boolean bsBgGradient) {
    this.bsBgGradient = bsBgGradient;
  }

  public boolean getBsDarkMode() {
    return bsDarkMode;
  }

  public void setBsDarkMode(boolean bsDarkMode) {
    this.bsDarkMode = bsDarkMode;
  }
  
  public void addAllToModel(Model model) {
    model.addAttribute("bsBgGradient", bsBgGradient);
    model.addAttribute("bsDarkMode", bsDarkMode);
  }
}
