package jp.ecuacion.splib.web.bean;

public abstract class RedirectUrlPageBean extends RedirectUrlBean {

  private String subFunction;
  private String page;

  public RedirectUrlPageBean() {
    this(null);
  }

  public RedirectUrlPageBean(String page) {
    this(null, page);
  }

  public RedirectUrlPageBean(String subFunction, String page) {
    super();
    this.subFunction = subFunction;
    this.page = page;
  }

  public String getUrl(String loginState, String function,
      String defaultSubFunction, String defaultPage) {
    String subFuncPart = (subFunction == null || subFunction.equals("")
        ? (defaultSubFunction == null || defaultSubFunction.equals("") ? ""
            : "/" + defaultSubFunction)
        : "/" + subFunction);
    String urlPath = getProtocol() + ":/" + loginState + "/" + function + subFuncPart
        + "/" + (page == null || page.equals("") ? defaultPage : page) + getParamsString();
    return urlPath;
  }
}
