/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.service;

import java.util.Optional;
import jp.ecuacion.lib.core.entity.AbstractEntity;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import jp.ecuacion.splib.jpa.repository.SplibRepository;
import org.springframework.orm.ObjectOptimisticLockingFailureException;

public interface SplibJpaServiceInterface<E extends AbstractEntity> {
    public void putNullToAuditingFields(E var1);

    public SplibRepository<E, Long> getRepositoryForOptimisticLocking();

    public Object getVersion(E var1);

    default public AbstractEntity findAndOptimisticLockingCheck(String id, String versionInScreen, ActionPattern pattern) throws AppException {
        Optional optional = this.getRepositoryForOptimisticLocking().findById((Object)Long.valueOf(id));
        if (pattern == ActionPattern.DELETE && optional.isEmpty()) {
            String msg = "jp.ecuacion.splib.web.common.message.sameRecordAlreadyDeleted";
            throw new CustomizedValidationAppException(msg);
        }
        AbstractEntity e = (AbstractEntity)optional.get();
        if (pattern == ActionPattern.EDIT || pattern == ActionPattern.DELETE) {
            this.putNullToAuditingFields(e);
        }
        if (!versionInScreen.equals(this.getVersion(e).toString())) {
            throw new ObjectOptimisticLockingFailureException("some class", (Object)id);
        }
        return e;
    }

    public static enum ActionPattern {
        GET_UPDATE_FORM,
        EDIT,
        DELETE;

    }
}

