/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.splib.core.form.record.SplibRecord;
import jp.ecuacion.splib.web.bean.RedirectUrlBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageOnAppExceptionBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageOnSuccessBean;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.form.SplibListForm;
import jp.ecuacion.splib.web.form.SplibSearchForm;
import jp.ecuacion.splib.web.service.SplibSearchListService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public abstract class SplibSearchListController<S extends SplibSearchForm, L extends SplibListForm<?>>
extends SplibGeneralController {
    @Autowired
    private S newSearchForm;

    @Override
    public abstract SplibSearchListService getService();

    public SplibSearchListController(@Nonnull String function) {
        super(function, "searchList");
    }

    public SplibSearchListController(@Nonnull String function, String rootRecordName) {
        super(function, "searchList", null, rootRecordName);
    }

    @Override
    public String getDefaultSubFunctionOnSuccess() {
        return "searchList";
    }

    @GetMapping(value={"page"})
    public String page(Model model, S searchForm, L listForm) throws Exception {
        searchForm = this.getProperSearchForm(model, searchForm);
        ((SplibGeneralForm)listForm).setDataKind(((SplibGeneralForm)searchForm).getDataKind());
        this.redirectUrlOnAppExceptionBean = new RedirectUrlPageOnAppExceptionBean();
        this.prepare(model, new SplibGeneralForm[]{searchForm, listForm});
        this.getService().setDataToForm((SplibSearchForm)searchForm, (SplibListForm<?>)listForm);
        return this.getReturnStringToShowPage();
    }

    @GetMapping(value={"action"}, params={"search"})
    public String search(Model model, S searchForm, L listForm) throws Exception {
        return this.page(model, searchForm, listForm);
    }

    @GetMapping(value={"action"}, params={"action=searchAgain"})
    public String searchAgain(Model model, S searchForm, L listForm) throws Exception {
        return this.search(model, searchForm, listForm);
    }

    protected S getProperSearchForm(Model model, S searchForm) {
        String formName = this.function + "SearchForm";
        String key = this.getSessionKey(formName, searchForm);
        if (searchForm != null) {
            if (((SplibSearchForm)searchForm).isRequestFromSearchForm()) {
                this.request.getSession().setAttribute(key, searchForm);
            }
            if (this.request.getSession().getAttribute(key) == null) {
                this.request.getSession().setAttribute(key, searchForm);
            }
        } else if (this.request.getSession().getAttribute(formName) == null) {
            throw new RuntimeException("f == null cannot be occurred.");
        }
        SplibSearchForm formUsedForSearch = (SplibSearchForm)this.request.getSession().getAttribute(this.getSessionKey(formName, searchForm));
        return (S)formUsedForSearch;
    }

    private String getSessionKey(String formName, S f) {
        return formName + (String)(f == null || ((SplibGeneralForm)f).getDataKind() == null || ((SplibGeneralForm)f).getDataKind().equals("") ? "" : "." + ((SplibGeneralForm)f).getDataKind());
    }

    @GetMapping(value={"action"}, params={"conditionClear"})
    public String searchConditionClear(Model model, S searchForm) throws Exception {
        String formName = this.function + "SearchForm";
        String sessionKey = formName + (String)(((SplibGeneralForm)searchForm).getDataKind() == null || ((SplibGeneralForm)searchForm).getDataKind().equals("") ? "" : "." + ((SplibGeneralForm)searchForm).getDataKind());
        this.request.getSession().setAttribute(sessionKey, this.newSearchForm);
        this.prepare();
        return this.getReturnStringOnSuccess(new RedirectUrlPageOnSuccessBean().noSuccessMessage().putParam("dataKind", ((SplibGeneralForm)searchForm).getDataKind()));
    }

    @PostMapping(value={"action"}, params={"delete"})
    public String delete(Model model, L listForm, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepare(model, new SplibGeneralForm[]{listForm});
        this.getService().delete((SplibListForm<? extends SplibRecord>)listForm, loginUser);
        return this.getReturnStringOnSuccess(new RedirectUrlPageOnSuccessBean().putParam("dataKind", ((SplibGeneralForm)listForm).getDataKind()));
    }

    @PostMapping(value={"action"}, params={"showInsertForm"})
    public String showInsertForm(Model model) throws InputValidationException, AppException {
        this.prepare();
        RedirectUrlBean bean = new RedirectUrlPageOnSuccessBean("edit", "page").noSuccessMessage().putParamMap(this.request.getParameterMap());
        return this.getReturnStringOnSuccess(bean);
    }

    @PostMapping(value={"action"}, params={"showUpdateForm"})
    public String showUpdateForm(Model model) throws InputValidationException, AppException {
        this.prepare();
        RedirectUrlBean bean = new RedirectUrlPageOnSuccessBean("edit", "page").noSuccessMessage().putParamMap(this.request.getParameterMap());
        return this.getReturnStringOnSuccess(bean);
    }
}

