/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.splib.web.bean.RedirectUrlBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPathBean;
import jp.ecuacion.splib.web.bean.RequestResultBean;
import jp.ecuacion.splib.web.controller.SplibBaseController;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibGeneralService;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.resource.NoResourceFoundException;

public abstract class SplibGeneralController
extends SplibBaseController {
    public static final String KEY = "controller";
    protected String function;
    protected String subFunction = "";
    protected String htmlFilenamePostfix;
    @Nonnull
    protected String rootRecordName;
    protected RedirectUrlBean redirectUrlOnAppExceptionBean;
    @Autowired
    private SplibUtil util;
    private StringUtil strUtil = new StringUtil();

    public abstract SplibGeneralService getService();

    public SplibGeneralController(@Nonnull String function) {
        this(function, null);
    }

    public SplibGeneralController(@Nonnull String function, String subFunction) {
        this(function, subFunction, null, function);
    }

    public SplibGeneralController(@Nonnull String function, String htmlFilenamePostfix, String recordName) {
        this.function = function;
        this.htmlFilenamePostfix = htmlFilenamePostfix;
        this.rootRecordName = recordName == null ? function : recordName;
    }

    public SplibGeneralController(@Nonnull String function, String subFunction, String htmlFilenamePostfix, String recordName) {
        this.function = function;
        this.subFunction = subFunction == null ? "" : subFunction;
        this.htmlFilenamePostfix = htmlFilenamePostfix;
        this.rootRecordName = recordName == null ? function : recordName;
    }

    public String getFunction() {
        return this.function;
    }

    public String getRootRecordName() {
        return this.rootRecordName;
    }

    public RedirectUrlBean getRedirectUrlOnAppExceptionBean() {
        return this.redirectUrlOnAppExceptionBean;
    }

    @ModelAttribute
    private void setCommonParamsToModel(Model model) {
        model.addAttribute("function", (Object)this.function);
        model.addAttribute("rootRecordName", (Object)this.rootRecordName);
    }

    protected String getReturnStringToShowPage() {
        return this.getDefaultHtmlFileName();
    }

    protected String getReturnStringOnSuccess(Model model) {
        return this.getReturnStringOnSuccess(model, this.getDefaultHtmlFileName(), true);
    }

    protected String getReturnStringOnSuccess(Model model, boolean needsSuccessMessage) {
        return this.getReturnStringOnSuccess(model, this.getDefaultHtmlFileName(), needsSuccessMessage);
    }

    protected String getReturnStringOnSuccess(Model model, String page) {
        return this.getReturnStringOnSuccess(model, page, true);
    }

    protected String getReturnStringOnSuccess(Model model, String page, boolean needsSuccessMessage) {
        if (needsSuccessMessage) {
            RequestResultBean bean = (RequestResultBean)model.getAttribute("responseMessages");
            bean.setNeedsSuccessMessage(true);
        }
        return page;
    }

    protected String getReturnStringOnSuccess(RedirectUrlBean redirectUrlBean) {
        if (redirectUrlBean instanceof RedirectUrlPageBean) {
            return ((RedirectUrlPageBean)redirectUrlBean).getUrl(this.util.getLoginState(), this.function, this.getDefaultSubFunctionOnSuccess(), this.getDefaultPageOnSuccess());
        }
        if (redirectUrlBean instanceof RedirectUrlPathBean) {
            return ((RedirectUrlPathBean)redirectUrlBean).getUrl();
        }
        throw new RuntimeException("RedirectUrlBean\u304c\u60f3\u5b9a\u5916\u306e\u5024\u3067\u3059\u3002" + redirectUrlBean);
    }

    @GetMapping(value={"action"})
    public void throw404() throws NoResourceFoundException {
        throw new NoResourceFoundException(HttpMethod.GET, "from SplibGeneralController");
    }

    @GetMapping(value={"action"}, params={"submitOnChangeToRefresh=true"})
    @PostMapping(value={"action"}, params={"submitOnChangeToRefresh=true"})
    public String submitOnChangeToRefresh(SplibGeneralForm f, Model model) throws Exception {
        this.prepare(model, f);
        model.addAttribute(this.function + this.strUtil.capitalize(this.subFunction) + "Form", (Object)f);
        this.getService().prepareForm(f);
        return this.function + this.strUtil.capitalize(this.subFunction);
    }

    public String getDefaultHtmlFileName() {
        return this.function + this.strUtil.capitalize(this.htmlFilenamePostfix == null ? this.subFunction : this.htmlFilenamePostfix);
    }

    public String getDefaultSubFunctionOnSuccess() {
        return this.subFunction;
    }

    public String getDefaultSubFunctionOnAppException() {
        return this.subFunction;
    }

    public String getDefaultPageOnSuccess() {
        return "page";
    }

    public String getDefaultPageOnAppException() {
        return "page";
    }

    protected void prepare() throws InputValidationException, AppException {
        this.prepare(null, null, null, false, new SplibGeneralForm[0]);
    }

    protected void prepare(Model model, SplibGeneralForm ... nonValidationTargetForms) throws InputValidationException, AppException {
        this.prepare(model, null, null, false, nonValidationTargetForms);
    }

    protected void prepare(Model model, SplibGeneralForm validationTargetForm, BindingResult result, SplibGeneralForm ... nonValidationTargetForms) throws InputValidationException, AppException {
        this.prepare(model, validationTargetForm, result, true, nonValidationTargetForms);
    }

    private void prepare(Model model, SplibGeneralForm validationTargetForm, BindingResult result, boolean needsValidationCheck, SplibGeneralForm ... nonValidationTargetForms) throws InputValidationException, AppException {
        ArrayList<SplibGeneralForm> allFormList = new ArrayList<SplibGeneralForm>(Arrays.asList(nonValidationTargetForms));
        if (validationTargetForm != null) {
            allFormList.add(validationTargetForm);
        }
        for (SplibGeneralForm form : allFormList) {
            model.addAttribute((Object)form);
            this.getService().prepareForm(form);
        }
        this.request.setAttribute(KEY, (Object)this);
        this.transactionTokenCheck();
        if (needsValidationCheck) {
            this.validationCheck(validationTargetForm, result);
        }
    }

    protected void transactionTokenCheck() throws CustomizedValidationAppException {
        String tokenFromHtml = this.request.getParameter("transactionToken");
        Set tokenSet = (Set)this.request.getSession().getAttribute("transactionToken");
        if (tokenSet != null && tokenFromHtml != null) {
            if (!tokenSet.contains(tokenFromHtml)) {
                String msgId = "jp.ecuacion.splib.web.common.message.tokenInvalidate";
                throw new CustomizedValidationAppException(msgId);
            }
            tokenSet.remove(tokenFromHtml);
        }
    }

    private void validationCheck(SplibGeneralForm form, BindingResult result) throws InputValidationException {
        boolean hasNotEmptyError = false;
        hasNotEmptyError = form.hasNotEmptyError();
        if (hasNotEmptyError || result != null && result.hasErrors()) {
            throw new InputValidationException(form);
        }
    }
}

