/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.splib.core.form.record.SplibRecord;
import jp.ecuacion.splib.web.bean.RedirectUrlBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageOnSuccessBean;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.form.SplibListForm;
import jp.ecuacion.splib.web.form.SplibSearchForm;
import jp.ecuacion.splib.web.service.SplibSearchListService;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

public abstract class SplibSearchListController<S extends SplibSearchForm, L extends SplibListForm<? extends SplibRecord>>
extends SplibGeneralController {
    protected abstract S getNewSearchForm();

    @Override
    public abstract SplibSearchListService getService();

    public SplibSearchListController(@Nonnull String function) {
        super(function, "searchList", function);
    }

    public SplibSearchListController(@Nonnull String function, String rootRecordName) {
        super(function, "searchList", rootRecordName);
    }

    @Override
    public String getDefaultSubFunctionOnSuccess() {
        return "searchList";
    }

    @GetMapping(value={"page"})
    public String page(Model model, S f) throws Exception {
        S searchForm = this.getProperSearchForm(model, f);
        SplibListForm<? extends SplibRecord> listForm = this.getService().getListForm((SplibSearchForm)searchForm);
        listForm.setDataKind(((SplibGeneralForm)searchForm).getDataKind());
        model.addAttribute(this.function + "ListForm", listForm);
        return this.getReturnStringOnShowingPage();
    }

    @GetMapping(value={"action"}, params={"search"})
    public String search(Model model, S f) throws Exception {
        return this.page(model, f);
    }

    @GetMapping(value={"action"}, params={"action=searchAgain"})
    public String searchAgain(Model model, S f) throws Exception {
        return this.search(model, f);
    }

    protected S getProperSearchForm(Model model, S f) {
        String formName = this.function + "SearchForm";
        String key = this.getSessionKey(formName, f);
        if (f != null) {
            if (((SplibSearchForm)f).isRequestFromSearchForm()) {
                this.request.getSession().setAttribute(key, f);
            }
            if (this.request.getSession().getAttribute(key) == null) {
                this.request.getSession().setAttribute(key, f);
            }
        } else if (this.request.getSession().getAttribute(formName) == null) {
            throw new RuntimeException("f == null cannot be occurred.");
        }
        SplibSearchForm formUsedForSearch = (SplibSearchForm)this.request.getSession().getAttribute(this.getSessionKey(formName, f));
        model.addAttribute(formName, (Object)formUsedForSearch);
        return (S)formUsedForSearch;
    }

    private String getSessionKey(String formName, S f) {
        return formName + (String)(f == null || ((SplibGeneralForm)f).getDataKind() == null || ((SplibGeneralForm)f).getDataKind().equals("") ? "" : "." + ((SplibGeneralForm)f).getDataKind());
    }

    @GetMapping(value={"action"}, params={"conditionClear"})
    public String searchConditionClear(Model model, S f) throws MultipleAppException {
        String formName = this.function + "SearchForm";
        String sessionKey = formName + (String)(((SplibGeneralForm)f).getDataKind() == null || ((SplibGeneralForm)f).getDataKind().equals("") ? "" : "." + ((SplibGeneralForm)f).getDataKind());
        this.request.getSession().setAttribute(sessionKey, null);
        return this.getReturnStringOnSuccess(new RedirectUrlPageOnSuccessBean().noSuccessMessage().putParam("dataKind", ((SplibGeneralForm)f).getDataKind()));
    }

    @GetMapping(value={"action"}, params={"delete"})
    public String delete(Model model, L f, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepare((SplibGeneralForm)f, model);
        this.getService().delete((SplibListForm<? extends SplibRecord>)f, loginUser);
        return this.getReturnStringOnSuccess(new RedirectUrlPageOnSuccessBean().putParam("dataKind", ((SplibGeneralForm)f).getDataKind()));
    }

    @GetMapping(value={"action"}, params={"showInsertForm"})
    public String showInsertForm(Model model) {
        RedirectUrlBean bean = new RedirectUrlPageOnSuccessBean("edit", "page").noSuccessMessage().putParamMap(this.request.getParameterMap());
        return this.getReturnStringOnSuccess(bean);
    }

    @GetMapping(value={"action"}, params={"showUpdateForm"})
    public String showUpdateForm(Model model) {
        RedirectUrlBean bean = new RedirectUrlPageOnSuccessBean("edit", "page").noSuccessMessage().putParamMap(this.request.getParameterMap());
        return this.getReturnStringOnSuccess(bean);
    }
}

