/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.util;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.splib.core.container.DatetimeFormatParameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SplibUtil {
    @Autowired
    HttpServletRequest request;
    @Autowired
    private ServletContext servletContext;

    public DatetimeFormatParameters getParams(HttpServletRequest request) {
        DatetimeFormatParameters params = new DatetimeFormatParameters();
        String strOffset = (String)request.getSession().getAttribute("zoneOffset");
        if (strOffset == null) {
            strOffset = "0";
        }
        params.setZoneOffsetWithJsMinutes(Integer.valueOf(strOffset).intValue());
        return params;
    }

    public String getLoginState() {
        String urlPath = this.request.getRequestURI();
        DetailLogger logger = new DetailLogger();
        logger.warn("servletContext.getContextPath() : " + this.servletContext.getContextPath());
        logger.warn("urlPath : " + urlPath);
        String tmp = urlPath.substring(1);
        Object loginState = tmp.substring(0, tmp.indexOf("/"));
        if (((String)loginState).equals("ecuacion")) {
            tmp = tmp.substring(tmp.indexOf("/") + 1);
            tmp = tmp.substring(0, tmp.indexOf("/"));
            loginState = (String)loginState + "-" + tmp;
        }
        ArrayList<String> loginStateCodeList = new ArrayList<String>();
        for (LoginStateEnum anEnum : LoginStateEnum.values()) {
            loginStateCodeList.add(anEnum.getCode());
        }
        if (!loginStateCodeList.contains(loginState)) {
            new RuntimeException("loginState not appropriate: loginState = " + (String)loginState + ", urlPath = " + urlPath);
        }
        return loginState;
    }

    public static enum LoginStateEnum {
        PUBLIC("public"),
        ACCOUNT("account"),
        ADMIN("admin"),
        ECUACION_PUBLIC("ecuacion-public");

        private String code;

        private LoginStateEnum(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

