package jp.ecuacion.splib.web.controller;

import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import jp.ecuacion.splib.web.form.LoginForm;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibGeneralService;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope("prototype")
@RequestMapping("/public/login")
public class LoginController extends SplibGeneralController {

  public LoginController() {
    super("login");
  }

  /**
   * Session Timeout状態で、ログインボタンや他のPOST系ボタンを押す場合、session timeoutで弾かれ /public/login/accessDeined
   * にredirectされるが、そのredirectもPOSTで行われるため 本処理にPOSTで入ってくることがある。それを考慮し@RequestMappingにしておく。
   */
  @GetMapping("page")
  public String page(Model model) throws CustomizedValidationAppException {
    model.addAttribute("loginForm", new LoginForm());
    return "login";
  }

  @Override
  public SplibGeneralService getService() {
    return new SplibGeneralService() {
      @Override
      public void prepareForm(SplibGeneralForm editForm) {}
    };
  }
}
