/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.advice;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import jp.ecuacion.splib.web.bean.RequestResultBean;
import jp.ecuacion.splib.web.bean.SplibModelAttributes;
import jp.ecuacion.splib.web.util.SplibUtil;
import jp.ecuacion.splib.web.util.internal.TransactionTokenUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ModelAttribute;

@ControllerAdvice
public class SplibControllerAdvice {
    public static final String REQUEST_KEY_MODEL = "REQUEST_KEY_MODEL";
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    private SplibModelAttributes modelAttr;
    @Autowired
    SplibUtil util;

    @ModelAttribute
    public void setObjectsToModel(Model model) {
        this.request.setAttribute(REQUEST_KEY_MODEL, (Object)model);
        String requestResultBeanKeyUuid = this.request.getParameter("errorMsgsKey");
        Map beanMap = (Map)this.request.getSession().getAttribute("responseMessages");
        if (requestResultBeanKeyUuid != null && !requestResultBeanKeyUuid.equals("") && beanMap != null && beanMap.get(requestResultBeanKeyUuid) != null) {
            model.addAttribute("responseMessages", beanMap.get(requestResultBeanKeyUuid));
            beanMap.clear();
        } else {
            model.addAttribute("responseMessages", (Object)new RequestResultBean());
        }
        model.addAttribute("transactionToken", (Object)new TransactionTokenUtil().issueNewToken(this.request));
        model.addAttribute("loginState", (Object)this.util.getLoginState());
        this.modelAttr.addAllToModel(model);
    }
}

