/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import java.util.Set;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.splib.web.advice.SplibExceptionHandlerData;
import jp.ecuacion.splib.web.bean.RedirectUrlBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPathBean;
import jp.ecuacion.splib.web.bean.RequestResultBean;
import jp.ecuacion.splib.web.controller.SplibBaseController;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibGeneralService;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;

public abstract class SplibGeneralController
extends SplibBaseController {
    protected String function;
    protected String subFunction;
    protected String htmlFilenamePostfix;
    @Nonnull
    protected String rootRecordName;
    protected RedirectUrlBean redirectUrlOnAppExceptionBean;
    private StringUtil strUtil = new StringUtil();

    public abstract SplibGeneralService getService();

    public SplibGeneralController(@Nonnull String function, LoginStateEnum loginState) {
        this(function, null, loginState);
    }

    public SplibGeneralController(@Nonnull String function, String functionPosxfix, LoginStateEnum loginState) {
        this(function, functionPosxfix, loginState, function);
    }

    public SplibGeneralController(@Nonnull String function, LoginStateEnum loginState, String recordName) {
        this(function, null, loginState, recordName);
    }

    public SplibGeneralController(@Nonnull String function, String subFunction, LoginStateEnum loginState, String recordName) {
        super(loginState);
        this.function = function;
        this.subFunction = subFunction == null ? "" : subFunction;
        this.rootRecordName = recordName == null ? function : recordName;
    }

    public SplibGeneralController(@Nonnull String function, String subFunction, String htmlFilenamePostfix, LoginStateEnum loginState, String recordName) {
        super(loginState);
        this.function = function;
        this.subFunction = subFunction == null ? "" : subFunction;
        this.htmlFilenamePostfix = htmlFilenamePostfix;
        this.rootRecordName = recordName == null ? function : recordName;
    }

    public String getFunctionName() {
        return this.function;
    }

    public String getRootRecordName() {
        return this.rootRecordName;
    }

    public RedirectUrlBean getRedirectUrlOnAppExceptionBean() {
        return this.redirectUrlOnAppExceptionBean;
    }

    @ModelAttribute
    private void setCommonParamsToModel(Model model) {
        model.addAttribute("function", (Object)this.function);
        model.addAttribute("rootRecordName", (Object)this.rootRecordName);
    }

    protected String getReturnStringOnShowingPage() {
        return this.getDefaultHtmlFileName();
    }

    protected String getReturnStringOnSuccess(Model model) {
        return this.getReturnStringOnSuccess(model, this.getDefaultHtmlFileName(), true);
    }

    protected String getReturnStringOnSuccess(Model model, boolean needsSuccessMessage) {
        return this.getReturnStringOnSuccess(model, this.getDefaultHtmlFileName(), needsSuccessMessage);
    }

    protected String getReturnStringOnSuccess(Model model, String page) {
        return this.getReturnStringOnSuccess(model, page, true);
    }

    protected String getReturnStringOnSuccess(Model model, String page, boolean needsSuccessMessage) {
        if (needsSuccessMessage) {
            RequestResultBean bean = (RequestResultBean)model.getAttribute("responseMessages");
            bean.setNeedsSuccessMessage(true);
        }
        return page;
    }

    protected String getReturnStringOnSuccess(RedirectUrlBean redirectUrlBean) {
        if (redirectUrlBean instanceof RedirectUrlPageBean) {
            return ((RedirectUrlPageBean)redirectUrlBean).getUrl(this.loginState, this.function, this.getDefaultSubFunctionOnSuccess(), this.getDefaultPageOnSuccess());
        }
        if (redirectUrlBean instanceof RedirectUrlPathBean) {
            return ((RedirectUrlPathBean)redirectUrlBean).getUrl();
        }
        throw new RuntimeException("RedirectUrlBean\u304c\u60f3\u5b9a\u5916\u306e\u5024\u3067\u3059\u3002" + redirectUrlBean);
    }

    @GetMapping(value={"action"}, params={"submitOnChangeToRefresh=true"})
    @PostMapping(value={"action"}, params={"submitOnChangeToRefresh=true"})
    public String submitOnChangeToRefresh(SplibGeneralForm f, Model model) throws Exception {
        this.prepare(f, model);
        model.addAttribute(this.function + this.strUtil.capitalize(this.subFunction) + "Form", (Object)f);
        this.getService().prepareForm(f);
        return this.function + this.strUtil.capitalize(this.subFunction);
    }

    public String getDefaultHtmlFileName() {
        return this.function + this.strUtil.capitalize(this.htmlFilenamePostfix == null ? this.subFunction : this.htmlFilenamePostfix);
    }

    public String getDefaultSubFunctionOnSuccess() {
        return this.subFunction;
    }

    public String getDefaultSubFunctionOnAppException() {
        return this.subFunction;
    }

    public String getDefaultPageOnSuccess() {
        return "page";
    }

    public String getDefaultPageOnAppException() {
        return "page";
    }

    protected void commonProc(SplibGeneralForm form, Model model, BindingResult result, boolean needsValidationCheck) throws InputValidationException, AppException {
        this.tokenCheck();
        if (needsValidationCheck) {
            this.validationCheck(form, result);
        }
    }

    protected void tokenCheck() throws CustomizedValidationAppException {
        String tokenFromHtml = this.request.getParameter("transactionToken");
        Set tokenSet = (Set)this.request.getSession().getAttribute("transactionToken");
        if (tokenSet != null && tokenFromHtml != null) {
            if (!tokenSet.contains(tokenFromHtml)) {
                String msgId = "jp.ecuacion.splib.web.common.message.tokenInvalidate";
                throw new CustomizedValidationAppException(msgId);
            }
            tokenSet.remove(tokenFromHtml);
        }
    }

    private void validationCheck(SplibGeneralForm form, BindingResult result) throws InputValidationException {
        boolean hasNotEmptyError = false;
        hasNotEmptyError = form.hasNotEmptyError();
        if (hasNotEmptyError || result != null && result.hasErrors()) {
            throw new InputValidationException(form);
        }
    }

    protected void prepare(SplibGeneralForm inputForm, Model model) throws InputValidationException, AppException {
        this.prepare(inputForm, model, null, null, false);
    }

    protected void prepare(SplibGeneralForm inputForm, Model model, String nextPageOnError) throws InputValidationException, AppException {
        this.prepare(inputForm, model, nextPageOnError, null, false);
    }

    protected void prepare(SplibGeneralForm inputForm, Model model, BindingResult result) throws InputValidationException, AppException {
        this.prepare(inputForm, model, null, result, true);
    }

    protected void prepare(SplibGeneralForm inputForm, Model model, String nextPageOnError, BindingResult result) throws InputValidationException, AppException {
        this.prepare(inputForm, model, nextPageOnError, result, true);
    }

    private void prepare(SplibGeneralForm inputForm, Model model, String nextPageOnError, BindingResult result, boolean needsValidationCheck) throws InputValidationException, AppException {
        model.addAttribute(this.function + "Form", (Object)inputForm);
        SplibExceptionHandlerData info = new SplibExceptionHandlerData(this, inputForm, nextPageOnError);
        this.request.setAttribute("ecuacion.spring.mvc.infoForErrorHandling", (Object)info);
        this.commonProc(inputForm, model, result, needsValidationCheck);
    }
}

