/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.beans.PropertyEditor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jp.ecuacion.splib.jpa.entitymanager.DbAccessManagerWithSpringJpa;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.lang.Nullable;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;

public abstract class SplibBaseController {
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected DbAccessManagerWithSpringJpa dbAccessManager;
    protected LoginStateEnum loginState;

    public SplibBaseController(LoginStateEnum loginState) {
        this.loginState = loginState;
    }

    public LoginStateEnum getLoginState() {
        return this.loginState;
    }

    @ModelAttribute
    private void setCommonParamsToModel(Model model) {
        model.addAttribute("loginState", (Object)this.loginState.getCode());
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(true));
        binder.registerCustomEditor(Boolean.class, (PropertyEditor)((Object)new NullSupportCustomBooleanEditor()));
    }

    static class NullSupportCustomBooleanEditor
    extends CustomBooleanEditor {
        public NullSupportCustomBooleanEditor() {
            super(false);
        }

        public void setAsText(@Nullable String text) throws IllegalArgumentException {
            if (text == null || text.equals("") || text.equals("null")) {
                this.setValue(null);
                return;
            }
            List<String> list = Arrays.asList((text = text.trim()).split(","));
            if (list.size() > 1) {
                if (list.size() > 2) {
                    throw new RuntimeException("Unpresumable.");
                }
                Collections.sort(list);
                if (!list.get(0).equalsIgnoreCase("OFF") || !list.get(1).equalsIgnoreCase("ON")) {
                    throw new RuntimeException("Unpresumable.");
                }
                this.setValue(Boolean.TRUE);
                return;
            }
            super.setAsText(text);
        }
    }
}

