/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.splib.web.advice.SplibExceptionHandlerData;
import jp.ecuacion.splib.web.bean.RedirectUrlBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageOnSuccessBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPathBean;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.form.SplibEditForm;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibEditService;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public abstract class SplibEditController<E extends SplibEditForm>
extends SplibGeneralController {
    private PageTemplatePatternEnum pageTemplatePattern;
    protected RedirectUrlPathBean redirectPathOnSuccess;

    public SplibEditController(PageTemplatePatternEnum pageTemplatePattern, @Nonnull String functionName, LoginStateEnum loginState) {
        this(pageTemplatePattern, functionName, loginState, functionName);
    }

    public SplibEditController(PageTemplatePatternEnum pageTemplatePattern, @Nonnull String functionName, LoginStateEnum loginState, String rootRecordName) {
        super(functionName, "edit", loginState, rootRecordName);
        this.pageTemplatePattern = pageTemplatePattern;
    }

    @Override
    public String getDefaultFunctionNamePostfixOnSuccess() {
        return this.pageTemplatePattern == PageTemplatePatternEnum.SINGLE ? "edit" : "searchList";
    }

    @GetMapping(value={"page"}, params={"showInsertForm"})
    public String showInsertForm(Model model, E f) throws AppException {
        this.prepareWithMovingToListOnError((SplibGeneralForm)f, model);
        SplibEditForm form = ((SplibEditService)this.getService()).getInsertForm((SplibEditForm)f);
        form.setIsInsert(true);
        form.setDataKind(((SplibGeneralForm)f).getDataKind());
        model.addAttribute(this.functionName + "EditForm", (Object)form);
        return this.functionName + "Edit";
    }

    @GetMapping(value={"page"}, params={"showUpdateForm"})
    public String showUpdateForm(Model model, E f) throws Exception {
        this.prepareWithMovingToListOnError((SplibGeneralForm)f, model);
        SplibEditForm form = ((SplibEditService)this.getService()).getUpdateForm((SplibEditForm)f);
        form.setIsInsert(false);
        form.setDataKind(((SplibGeneralForm)f).getDataKind());
        model.addAttribute(this.functionName + "EditForm", (Object)form);
        return this.functionName + "Edit";
    }

    @PostMapping(value={"action"}, params={"insertOrUpdate"})
    public String edit(@Validated E f, BindingResult result, Model model, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepare((SplibGeneralForm)f, model, this.functionName + "Edit", result);
        ((SplibEditService)this.getService()).edit((SplibEditForm)f, loginUser);
        RedirectUrlBean redirectBean = this.redirectPathOnSuccess == null ? new RedirectUrlPageOnSuccessBean() : this.redirectPathOnSuccess;
        redirectBean.putParam("dataKind", ((SplibGeneralForm)f).getDataKind());
        return this.getReturnStringOnSuccess(redirectBean);
    }

    @PostMapping(value={"action"}, params={"back"})
    public String back(@Validated E f, BindingResult result, Model model) {
        return this.getReturnStringOnSuccess(new RedirectUrlPageOnSuccessBean("searchList", "page").noSuccessMessage().putParam("dataKind", ((SplibGeneralForm)f).getDataKind()));
    }

    @Override
    protected void prepare(SplibGeneralForm form, Model model, String nextPageOnError, BindingResult result) throws InputValidationException, AppException {
        if (form instanceof SplibEditForm) {
            this.getService().prepareForm((SplibEditForm)form);
        }
        super.prepare(form, model, nextPageOnError, result);
    }

    protected void prepareWithMovingToListOnError(SplibGeneralForm form, Model model, BindingResult result) throws InputValidationException, AppException {
        SplibExceptionHandlerData info = new SplibExceptionHandlerData(this, form);
        this.request.setAttribute("ecuacion.spring.mvc.infoForErrorHandling", (Object)info);
        this.commonProc(form, model, result, false);
    }

    protected void prepareWithMovingToListOnError(SplibGeneralForm form, Model model) throws InputValidationException, AppException {
        this.prepareWithMovingToListOnError(form, model, null);
    }

    public static enum PageTemplatePatternEnum {
        SINGLE,
        PAIR_WITH_SEARCH_LIST;

    }
}

