package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.splib.core.form.record.SplibRecord;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.form.SplibListForm;
import jp.ecuacion.splib.web.form.SplibSearchForm;
import jp.ecuacion.splib.web.service.SplibSearchListJpaService;
import jp.ecuacion.splib.web.service.SplibSearchListService;
import org.springframework.ui.Model;

public abstract class SplibSearchListJpaController
    <S extends SplibSearchForm, L extends SplibListForm<? extends SplibRecord>>
    extends SplibSearchListController<S, L> {

  public abstract SplibSearchListJpaService<?> getJpaService();

  public SplibSearchListService getService() {
    return getJpaService();
  }

  public SplibSearchListJpaController(@Nonnull String functionName, LoginStateEnum loginState) {
    super(functionName, loginState);
  }

  public SplibSearchListJpaController(@Nonnull String functionName, LoginStateEnum loginState,
      String rootRecordName) {
    super(functionName, loginState, rootRecordName);
  }

  public String search(Model model, S f) throws Exception {
    getJpaService().setEntityManager(dbAccessManager.getEntityManager());

    return super.page(model, f);
  }
}
