package jp.ecuacion.splib.web.bean;

import jp.ecuacion.splib.web.enums.LoginStateEnum;

public abstract class RedirectUrlPageBean extends RedirectUrlBean {

  private String functionNamePostfix;
  private String page;

  public RedirectUrlPageBean() {
    this(null);
  }

  public RedirectUrlPageBean(String page) {
    this(null, page);
  }

  public RedirectUrlPageBean(String functionNamePostfix, String page) {
    super();
    this.functionNamePostfix = functionNamePostfix;
    this.page = page;
  }

  public String getUrl(LoginStateEnum loginState, String functionName,
      String defaultFunctionNamePostfix, String defaultPage) {
    String fnPfPart = (functionNamePostfix == null || functionNamePostfix.equals("")
        ? (defaultFunctionNamePostfix == null || defaultFunctionNamePostfix.equals("") ? ""
            : "/" + defaultFunctionNamePostfix)
        : "/" + functionNamePostfix);
    String urlPath = getProtocol() + ":/" + loginState.getCode() + "/" + functionName + fnPfPart
        + "/" + (page == null || page.equals("") ? defaultPage : page) + getParamsString();
    return urlPath;
  }
}
