/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import java.util.Map;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.splib.core.form.record.SplibRecord;
import jp.ecuacion.splib.web.advice.SplibExceptionHandlerData;
import jp.ecuacion.splib.web.bean.RedirectUrlOnSuccessPageBean;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.form.SplibListForm;
import jp.ecuacion.splib.web.form.SplibSearchForm;
import jp.ecuacion.splib.web.service.SplibSearchListService;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;

public abstract class SplibSearchListController<S extends SplibSearchForm, L extends SplibListForm<? extends SplibRecord>>
extends SplibGeneralController {
    protected abstract S getNewSearchForm();

    @Override
    public abstract SplibSearchListService getService();

    public SplibSearchListController(LoginStateEnum loginState, @Nonnull String functionName, String rootRecordName) {
        super(loginState, functionName, rootRecordName);
    }

    public SplibSearchListController(LoginStateEnum loginState, @Nonnull String functionName) {
        super(loginState, functionName, functionName);
    }

    @GetMapping(value={"search"})
    public String search(Model model, S f) throws Exception {
        S searchForm = this.getProperSearchForm(model, f);
        SplibListForm<? extends SplibRecord> listForm = this.getService().getListForm((SplibSearchForm)searchForm);
        listForm.setDataKind(((SplibGeneralForm)searchForm).getDataKind());
        model.addAttribute(this.functionName + "ListForm", listForm);
        return this.functionName + "SearchList";
    }

    public String search(Model model, String menuName) throws Exception {
        S form = this.getNewSearchForm();
        ((SplibGeneralForm)form).setDataKind(menuName);
        return this.search(model, form);
    }

    protected S getProperSearchForm(Model model, S f) {
        String formName = this.functionName + "SearchForm";
        String key = this.getSessionKey(formName, f);
        if (f != null) {
            if (((SplibSearchForm)f).isRequestFromSearchForm()) {
                this.request.getSession().setAttribute(key, f);
            }
            if (this.request.getSession().getAttribute(key) == null) {
                this.request.getSession().setAttribute(key, f);
            }
        } else if (this.request.getSession().getAttribute(formName) == null) {
            throw new RuntimeException("f == null cannot be occurred.");
        }
        SplibSearchForm formUsedForSearch = (SplibSearchForm)this.request.getSession().getAttribute(this.getSessionKey(formName, f));
        model.addAttribute(formName, (Object)formUsedForSearch);
        return (S)formUsedForSearch;
    }

    private String getSessionKey(String formName, S f) {
        return formName + (String)(f == null || ((SplibGeneralForm)f).getDataKind() == null || ((SplibGeneralForm)f).getDataKind().equals("") ? "" : "." + ((SplibGeneralForm)f).getDataKind());
    }

    @GetMapping(value={"search"}, params={"conditionClear"})
    public String searchConditionClear(Model model, S f) throws MultipleAppException {
        String formName = this.functionName + "SearchForm";
        String sessionKey = formName + (String)(((SplibGeneralForm)f).getDataKind() == null || ((SplibGeneralForm)f).getDataKind().equals("") ? "" : "." + ((SplibGeneralForm)f).getDataKind());
        this.request.getSession().setAttribute(sessionKey, null);
        return this.getReturnStringOnSuccess(new RedirectUrlOnSuccessPageBean("search", "dataKind", ((SplibGeneralForm)f).getDataKind()));
    }

    @GetMapping(value={"list"}, params={"delete"})
    public String delete(Model model, L f, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepareWithMovingToListOnError((SplibGeneralForm)f, model);
        this.getService().delete((SplibListForm<? extends SplibRecord>)f, loginUser);
        return this.getReturnStringOnSuccess(new RedirectUrlOnSuccessPageBean("search", "dataKind", ((SplibGeneralForm)f).getDataKind()));
    }

    @GetMapping(value={"list"}, params={"showInsertForm"})
    public String showInsertForm(Model model) {
        RedirectUrlOnSuccessPageBean bean = new RedirectUrlOnSuccessPageBean("edit", (Map<String, String[]>)this.request.getParameterMap());
        return this.getReturnStringOnSuccess(bean);
    }

    @GetMapping(value={"list"}, params={"showUpdateForm"})
    public String showUpdateForm(Model model) {
        RedirectUrlOnSuccessPageBean bean = new RedirectUrlOnSuccessPageBean("edit", (Map<String, String[]>)this.request.getParameterMap());
        return this.getReturnStringOnSuccess(bean);
    }

    @Override
    protected void prepare(SplibGeneralForm form, Model model, String nextPageOnError, BindingResult result) throws InputValidationException, AppException {
        super.prepare(form, model, nextPageOnError, result);
    }

    protected void prepareWithMovingToListOnError(SplibGeneralForm form, Model model, BindingResult result) throws InputValidationException, AppException {
        SplibExceptionHandlerData info = new SplibExceptionHandlerData(this, form);
        this.request.setAttribute("ecuacion.spring.mvc.infoForErrorHandling", (Object)info);
        this.commonProc(form, model, result, false);
    }

    protected void prepareWithMovingToListOnError(SplibGeneralForm form, Model model) throws InputValidationException, AppException {
        this.prepareWithMovingToListOnError(form, model, null);
    }
}

