package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.splib.core.form.record.SplibRecord;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.form.SplibListForm;
import jp.ecuacion.splib.web.form.SplibSearchForm;
import jp.ecuacion.splib.web.service.SplibSearchListJpaService;
import jp.ecuacion.splib.web.service.SplibSearchListService;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

public abstract class SplibSearchListJpaController
    <S extends SplibSearchForm, L extends SplibListForm<? extends SplibRecord>>
    extends SplibSearchListController<S, L> {
  
  public abstract SplibSearchListJpaService<?> getJpaService();
  
  public SplibSearchListService getService() {
    return getJpaService();
  }

  public SplibSearchListJpaController(LoginStateEnum loginState, @Nonnull String functionName,
      String rootRecordName) {
    super(loginState, functionName, rootRecordName);
  }

  public SplibSearchListJpaController(LoginStateEnum loginState, @Nonnull String functionName) {
    super(loginState, functionName, functionName);
  }

  @GetMapping(value = "search")
  public String search(Model model, S f) throws Exception {
    getJpaService().setEntityManager(dbAccessManager.getEntityManager());
    
    return super.search(model, f);
  }
}
