package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.form.SplibEditForm;
import jp.ecuacion.splib.web.service.SplibEditJpaService;
import jp.ecuacion.splib.web.service.SplibEditService;

public abstract class SplibEditJpaController<E extends SplibEditForm>
    extends SplibEditController<E> {

  public abstract SplibEditJpaService<?> getJpaService();

  public SplibEditService getService() {
    return getJpaService();
  }

  public SplibEditJpaController(PageTemplatePatternEnum pageTemplatePattern,
      LoginStateEnum loginState, @Nonnull String functionName) {
    super(pageTemplatePattern, loginState, functionName);
  }

  public SplibEditJpaController(PageTemplatePatternEnum pageTemplatePattern,
      LoginStateEnum loginState, @Nonnull String functionName, String rootRecordName) {
    super(pageTemplatePattern, loginState, functionName, rootRecordName);
  }
}
