/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.splib.web.advice.SplibExceptionHandlerData;
import jp.ecuacion.splib.web.bean.RedirectUrlOnSuccessBean;
import jp.ecuacion.splib.web.bean.RedirectUrlOnSuccessPageBean;
import jp.ecuacion.splib.web.bean.RedirectUrlOnSuccessPathBean;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.form.SplibEditForm;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibEditService;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public abstract class SplibEditController<E extends SplibEditForm>
extends SplibGeneralController {
    private PageTemplatePatternEnum pageTemplatePattern;
    protected RedirectUrlOnSuccessPathBean redirectPathOnSuccess;

    public SplibEditController(PageTemplatePatternEnum pageTemplatePattern, LoginStateEnum loginState, @Nonnull String functionName) {
        super(loginState, functionName);
        this.pageTemplatePattern = pageTemplatePattern;
    }

    public SplibEditController(PageTemplatePatternEnum pageTemplatePattern, LoginStateEnum loginState, @Nonnull String functionName, String rootRecordName) {
        super(loginState, functionName, rootRecordName);
        this.pageTemplatePattern = pageTemplatePattern;
    }

    @Override
    public String getDefaultHtmlFileName() {
        return this.functionName + "Edit";
    }

    @Override
    public String getDefaultSuccessPage() {
        return this.pageTemplatePattern == PageTemplatePatternEnum.SINGLE ? "edit" : "search";
    }

    @GetMapping(value={"edit"}, params={"showInsertForm"})
    public String showInsertForm(Model model, E f) throws AppException {
        this.prepareWithMovingToListOnError((SplibGeneralForm)f, model);
        SplibEditForm form = ((SplibEditService)this.getService()).getInsertForm((SplibEditForm)f);
        form.setIsInsert(true);
        form.setMenuName(((SplibGeneralForm)f).getMenuName());
        model.addAttribute(this.functionName + "EditForm", (Object)form);
        return this.functionName + "Edit";
    }

    @GetMapping(value={"edit"}, params={"showUpdateForm"})
    public String showUpdateForm(Model model, E f) throws Exception {
        this.prepareWithMovingToListOnError((SplibGeneralForm)f, model);
        SplibEditForm form = ((SplibEditService)this.getService()).getUpdateForm((SplibEditForm)f);
        form.setIsInsert(false);
        form.setMenuName(((SplibGeneralForm)f).getMenuName());
        model.addAttribute(this.functionName + "EditForm", (Object)form);
        return this.functionName + "Edit";
    }

    protected String getUrlParams(String menuName, boolean needsAmpersand) {
        Object additionalString = "";
        if (menuName != null && !menuName.equals("")) {
            additionalString = (needsAmpersand ? "&" : "") + "menuName=" + menuName;
        }
        return additionalString;
    }

    @PostMapping(value={"edit"})
    public String edit(@Validated E f, BindingResult result, Model model, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepare((SplibGeneralForm)f, model, this.functionName + "Edit", result);
        ((SplibEditService)this.getService()).edit((SplibEditForm)f, loginUser);
        RedirectUrlOnSuccessBean redirectBean = this.redirectPathOnSuccess == null ? new RedirectUrlOnSuccessPageBean(this.getDefaultSuccessPage()) : this.redirectPathOnSuccess;
        redirectBean.putToParamMap("menuName", ((SplibGeneralForm)f).getMenuName());
        return this.getReturnStringOnSuccess(redirectBean);
    }

    @PostMapping(value={"edit"}, params={"back"})
    public String back(@Validated E f, BindingResult result, Model model) {
        return "redirect:/" + this.loginState.getCode() + "/" + this.functionName + "/search?" + this.getUrlParams(((SplibGeneralForm)f).getMenuName(), false);
    }

    @Override
    protected void prepare(SplibGeneralForm form, Model model, String nextPageOnError, BindingResult result) throws InputValidationException, AppException {
        if (form instanceof SplibEditForm) {
            this.getService().prepareForm((SplibEditForm)form);
        }
        super.prepare(form, model, nextPageOnError, result);
    }

    protected void prepareWithMovingToListOnError(SplibGeneralForm form, Model model, BindingResult result) throws InputValidationException, AppException {
        SplibExceptionHandlerData info = new SplibExceptionHandlerData(this, form);
        this.request.setAttribute("ecuacion.spring.mvc.infoForErrorHandling", (Object)info);
        this.commonProc(form, model, result, false);
    }

    protected void prepareWithMovingToListOnError(SplibGeneralForm form, Model model) throws InputValidationException, AppException {
        this.prepareWithMovingToListOnError(form, model, null);
    }

    public static enum PageTemplatePatternEnum {
        SINGLE,
        PAIR_WITH_SEARCH_LIST;

    }
}

