package jp.ecuacion.splib.web.util;

import java.util.Locale;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import org.springframework.stereotype.Component;

/**
 * thymeleaf側から呼ばれる想定のクラス。localeを加味したメッセージ表示を実施。
 * 裏ではPropertyFileUtilを呼び出しているのみ。PropertyFileUtilの機能が使える分#{...} より協力。 ただし、#{...}で問題ない部分はそれを使っても問題なし。
 */
@Component("msgUtil")
public class SplibMessageUtil {

  public SplibMessageUtil() {}

  public String get(Locale locale, String id) {
    boolean hasMsg = PropertyFileUtil.hasMsg(id);
    boolean hasField = PropertyFileUtil.hasFieldName(id);

    // 両方に存在する場合はエラー
    if (hasMsg && hasField) {
      String msg =
          "Key '" + id + "' has both in 'messages.properties' and 'field_names.properties'. "
              + "One of keys must be changed. (key : " + id + ")";
      throw new RuntimeException(msg);
    }
    
    if (!hasMsg && !hasField) {
      // message側のエラーメッセージを返す
      return PropertyFileUtil.getMsg(locale, id);
    }

    if (hasMsg) {
      return PropertyFileUtil.getMsg(locale, id);

    } else {
      return PropertyFileUtil.getFieldName(locale, id);
    }
    
    
  }
}
