package jp.ecuacion.splib.web.bean;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;

public abstract class RedirectUrlBean {

  /** 
   * html request parameterは同一keyを許すのでvalueは配列としておく。
   * ただし、配列として取り扱うべき場面は多くないので、極力配列でないStringでも取り扱えるようにする。
   */
  private final Map<String, String[]> paramMap;

  public RedirectUrlBean(Map<String, String[]> paramMap) {
    this.paramMap = new HashMap<>(paramMap);
  }

  public RedirectUrlBean(String paramKey, String paramValue) {
    paramMap = new HashMap<>();

    Objects.requireNonNull(paramKey);

    paramMap.put(paramKey, paramValue == null ? new String[] {""} : new String[] {paramValue});
  }

  /** 
   * paramPairsは、以下のように一つの子配列に一つのkeyとvalueを持たせる形で配列で渡す。
   * 例：new String[] {{key1, value1}, {key2, value2-1, value2-2}} 
   */
  public RedirectUrlBean(String[][] paramPairs) {
    paramMap = new HashMap<>();

    Objects.requireNonNull(paramPairs);

    for (int i = 0; i < paramPairs.length; i++) {
      Objects.requireNonNull(paramPairs[i]);

      String[] paramPair = paramPairs[i];
      Objects.requireNonNull(paramPair);
      if (paramPair.length < 2) {
        throw new RuntimeException("paramPairs[i].length must be equal to or greater than 2.");
      }

      List<String> list = Arrays.asList(paramPair);
      list.remove(0);
      String[] values = list.toArray(new String[list.size()]);
      
      Objects.requireNonNull(paramPair[0]);
      paramMap.put(paramPair[0], values);
    }
  }

  public Map<String, String[]> getParamMap() {
    return paramMap;
  }

  protected String getParamsString() {
    boolean is1st = true;
    StringBuilder sb = new StringBuilder();
    for (Entry<String, String[]> entry : paramMap.entrySet()) {
      for (String value : entry.getValue()) {
        if (is1st) {
          is1st = false;
          sb.append("?");

        } else {
          sb.append("&");
        }

        sb.append(entry.getKey() + "=" + value);
      }
    }

    return sb.toString();
  }
  
  public void putToParamMap(String key, String value) {
    getParamMap().put(key, new String[] {value});
  }
}
