/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import java.util.Set;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import jp.ecuacion.splib.web.advice.SplibExceptionHandlerData;
import jp.ecuacion.splib.web.bean.RedirectUrlOnAppExceptionBean;
import jp.ecuacion.splib.web.bean.RedirectUrlOnSuccessBean;
import jp.ecuacion.splib.web.bean.RedirectUrlOnSuccessPageBean;
import jp.ecuacion.splib.web.bean.RedirectUrlOnSuccessPathBean;
import jp.ecuacion.splib.web.controller.SplibBaseController;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibGeneralService;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;

public abstract class SplibGeneralController
extends SplibBaseController {
    protected String functionName;
    @Nonnull
    protected String rootRecordName;
    protected RedirectUrlOnAppExceptionBean redirectUrlOnAppExceptionBean;

    public abstract SplibGeneralService getService();

    public SplibGeneralController(LoginStateEnum loginState, @Nonnull String functionName) {
        super(loginState);
        this.functionName = functionName;
        this.rootRecordName = functionName;
    }

    public SplibGeneralController(LoginStateEnum loginState, @Nonnull String functionName, String rootRecordName) {
        this(loginState, functionName);
        this.rootRecordName = rootRecordName == null ? "" : rootRecordName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getRootRecordName() {
        return this.rootRecordName;
    }

    public RedirectUrlOnAppExceptionBean getRedirectUrlOnAppExceptionBean() {
        return this.redirectUrlOnAppExceptionBean;
    }

    @ModelAttribute
    private void setCommonParamsToModel(Model model) {
        model.addAttribute("functionName", (Object)this.functionName);
        model.addAttribute("rootRecordName", (Object)this.rootRecordName);
    }

    protected String getActionSuccessRedirectString(RedirectUrlOnSuccessBean redirectUrlBean) {
        if (redirectUrlBean instanceof RedirectUrlOnSuccessPageBean) {
            return ((RedirectUrlOnSuccessPageBean)redirectUrlBean).getUrl(this.loginState, this.functionName);
        }
        if (redirectUrlBean instanceof RedirectUrlOnSuccessPathBean) {
            return ((RedirectUrlOnSuccessPathBean)redirectUrlBean).getUrl();
        }
        throw new RuntimeException("RedirectUrlBean\u304c\u60f3\u5b9a\u5916\u306e\u5024\u3067\u3059\u3002" + redirectUrlBean);
    }

    @PostMapping(value={"action"}, params={"submitOnChangeToRefresh=true"})
    public String updateOptions(SplibGeneralForm f, Model model) throws Exception {
        this.prepare(f, model);
        model.addAttribute(this.functionName + "EditForm", (Object)f);
        model.addAttribute("testkey", (Object)"testvalue");
        model.addAttribute(this.functionName + "EditForm", (Object)f);
        model.addAttribute(this.functionName + "Edit2Form", (Object)f);
        this.getService().prepareForm(f);
        return this.functionName + "Edit";
    }

    public String getDefaultHtmlFileName() {
        return this.functionName;
    }

    public String getDefaultSuccessPage() {
        return "page";
    }

    public String getDefaultErrorPage() {
        return "page";
    }

    protected void commonProc(SplibGeneralForm form, Model model, BindingResult result, boolean needsValidationCheck) throws InputValidationException, AppException {
        this.tokenCheck();
        if (needsValidationCheck) {
            this.validationCheck(form, result);
        }
    }

    protected void tokenCheck() throws CustomizedValidationAppException {
        String tokenFromHtml = this.request.getParameter("transactionToken");
        Set tokenSet = (Set)this.request.getSession().getAttribute("transactionToken");
        if (tokenSet != null && tokenFromHtml != null) {
            if (!tokenSet.contains(tokenFromHtml)) {
                String msgId = "jp.ecuacion.splib.web.common.message.tokenInvalidate";
                throw new CustomizedValidationAppException(msgId);
            }
            tokenSet.remove(tokenFromHtml);
        }
    }

    private void validationCheck(SplibGeneralForm form, BindingResult result) throws InputValidationException {
        boolean hasNotEmptyError = false;
        hasNotEmptyError = form.hasNotEmptyError();
        if (hasNotEmptyError || result != null && result.hasErrors()) {
            throw new InputValidationException(form);
        }
    }

    protected void prepare(SplibGeneralForm inputForm, Model model) throws InputValidationException, AppException {
        this.prepare(inputForm, model, null, null, false);
    }

    protected void prepare(SplibGeneralForm inputForm, Model model, String nextPageOnError) throws InputValidationException, AppException {
        this.prepare(inputForm, model, nextPageOnError, null, false);
    }

    protected void prepare(SplibGeneralForm inputForm, Model model, BindingResult result) throws InputValidationException, AppException {
        this.prepare(inputForm, model, null, result, true);
    }

    protected void prepare(SplibGeneralForm inputForm, Model model, String nextPageOnError, BindingResult result) throws InputValidationException, AppException {
        this.prepare(inputForm, model, nextPageOnError, result, true);
    }

    private void prepare(SplibGeneralForm inputForm, Model model, String nextPageOnError, BindingResult result, boolean needsValidationCheck) throws InputValidationException, AppException {
        model.addAttribute(this.functionName + "Form", (Object)inputForm);
        SplibExceptionHandlerData info = new SplibExceptionHandlerData(this, inputForm, nextPageOnError);
        this.request.setAttribute("ecuacion.spring.mvc.infoForErrorHandling", (Object)info);
        this.commonProc(inputForm, model, result, needsValidationCheck);
    }
}

