package jp.ecuacion.splib.web.service;

import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.splib.web.form.SplibEditForm;
import org.springframework.security.core.userdetails.UserDetails;

public abstract class SplibEditService extends SplibGeneralService {

  public abstract SplibEditForm getInsertForm(SplibEditForm editForm) throws AppException;

  /**
   * 引数のformは、listから選択された行のidとversionを受け取るためのformとしてたまたまeditFormを使用しているのみ。
   * そのidを元にレコード全体を取得したものを改めてeditFormとして戻す。
   */
  public abstract SplibEditForm getUpdateForm(SplibEditForm editForm) throws Exception;

  public abstract void prepareEditForm(SplibEditForm editForm);

  public abstract void edit(SplibEditForm editForm, UserDetails loginUser) throws Exception;

  /** edit時にinsertかupdateかを判別する方法。小さな処理だが共通化しておく。 */
  protected boolean isInsert(String id) {
    return id == null || id.equals("");
  }
}
