/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.splib.web.advice.SplibExceptionHandlerData;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.form.SplibEditForm;
import jp.ecuacion.splib.web.form.SplibForm;
import jp.ecuacion.splib.web.service.SplibEditService;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public abstract class SplibEditController<E extends SplibEditForm>
extends SplibGeneralController<E> {
    public abstract SplibEditService getService();

    public SplibEditController(LoginStateEnum loginState, @Nonnull String functionName) {
        super(loginState, functionName);
    }

    public SplibEditController(LoginStateEnum loginState, @Nonnull String functionName, String rootRecordName) {
        super(loginState, functionName, rootRecordName);
    }

    @Override
    protected String[] getFunctionNamePostfixes() {
        return new String[]{"edit"};
    }

    @Override
    protected String getActionSuccessRedirectString() {
        return "redirect:" + (String)(this.getRedirectPathOnSuccess() == null ? "/" + this.loginState.getCode() + "/" + this.functionName + "/" + this.getDefaultSuccessPage() + "?success" : this.getRedirectPathOnSuccess());
    }

    @Override
    public String getDefaultSuccessPage() {
        return "search";
    }

    @GetMapping(value={"edit"}, params={"showInsertForm"})
    public String showInsertForm(Model model, E f) throws AppException {
        this.prepareWithMovingToListOnError((SplibForm)f, model);
        SplibEditForm form = this.getService().getInsertForm((SplibEditForm)f);
        form.setIsInsert(true);
        form.setMenuName(((SplibForm)f).getMenuName());
        model.addAttribute(this.functionName + "EditForm", (Object)form);
        return this.functionName + "Edit";
    }

    @GetMapping(value={"edit"}, params={"showUpdateForm"})
    public String showUpdateForm(Model model, E f) throws Exception {
        this.prepareWithMovingToListOnError((SplibForm)f, model);
        SplibEditForm form = this.getService().getUpdateForm((SplibEditForm)f);
        form.setIsInsert(false);
        form.setMenuName(((SplibForm)f).getMenuName());
        model.addAttribute(this.functionName + "EditForm", (Object)form);
        return this.functionName + "Edit";
    }

    protected String getUrlParams(String menuName, boolean needsAmpersand) {
        Object additionalString = "";
        if (menuName != null && !menuName.equals("")) {
            additionalString = (needsAmpersand ? "&" : "") + "menuName=" + menuName;
        }
        return additionalString;
    }

    @PostMapping(value={"edit"})
    public String edit(@Validated E f, BindingResult result, Model model, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepare((SplibForm)f, model, this.functionName + "Edit", result);
        this.getService().edit((SplibEditForm)f, loginUser);
        return this.getActionSuccessRedirectString() + this.getUrlParams(((SplibForm)f).getMenuName(), true);
    }

    @PostMapping(value={"edit"}, params={"back"})
    public String back(@Validated E f, BindingResult result, Model model) {
        return "redirect:/" + this.loginState.getCode() + "/" + this.functionName + "/search?" + this.getUrlParams(((SplibForm)f).getMenuName(), false);
    }

    @PostMapping(value={"edit"}, params={"updateDropDown=true"})
    public String updateOptions(E f, Model model) throws Exception {
        this.prepare((SplibForm)f, model, this.functionName + "Edit");
        model.addAttribute(this.functionName + "EditForm", f);
        return this.functionName + "Edit";
    }

    @Override
    protected void prepare(SplibForm form, Model model, String nextPageOnError, BindingResult result) throws InputValidationException, AppException {
        if (form instanceof SplibEditForm) {
            this.getService().prepareEditForm((SplibEditForm)form);
        }
        super.prepare(form, model, nextPageOnError, result);
    }

    protected void prepareWithMovingToListOnError(SplibForm form, Model model, BindingResult result) throws InputValidationException, AppException {
        SplibExceptionHandlerData info = new SplibExceptionHandlerData(this, form);
        this.request.setAttribute("ecuacion.spring.mvc.infoForErrorHandling", (Object)info);
        this.commonProc(form, model, result, false);
    }

    protected void prepareWithMovingToListOnError(SplibForm form, Model model) throws InputValidationException, AppException {
        this.prepareWithMovingToListOnError(form, model, null);
    }
}

