package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.form.SplibForm;

public abstract class SplibGeneralController<F extends SplibForm>
    extends SplibBaseWithRecordController {

  /** edit success時にredirectされる先を変更する場合に使用。通常は未設定で良い。 */
  private String editSuccessRedirectPath;

  public SplibGeneralController(LoginStateEnum loginState, @Nonnull String functionName,
      String rootRecordName) {
    super(loginState, functionName, rootRecordName);
  }

  public SplibGeneralController(LoginStateEnum loginState, @Nonnull String functionName) {
    super(loginState, functionName, functionName);
  }

  protected String getEditSuccessRedirectPath() {
    return this.editSuccessRedirectPath;
  }

  protected void setEditSuccessRedirectPath(String path) {
    this.editSuccessRedirectPath = path;
  }

  protected String getActionSuccessRedirectString() {
    return "redirect:"
        + (editSuccessRedirectPath == null
            ? "/" + loginState.getCode() + "/" + functionName + "/" + getDefaultSuccessPage()
                + "?success"
            : editSuccessRedirectPath);
  }

  /** 処理成功時の表示画面のdefault。 */
  public String getDefaultSuccessPage() {
    return "page";
  }

  /** エラー時の表示画面のdefault。 */
  public String getDefaultErrorPage() {
    return "page";
  }
}
