/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.service;

import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import jp.ecuacion.lib.core.entity.AbstractEntity;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.jpa.dbaccess.EntityManagerWrapper;
import jp.ecuacion.splib.core.container.DatetimeFormatParameters;
import jp.ecuacion.splib.core.form.record.SplibRecord;
import jp.ecuacion.splib.jpa.repository.SplibRepository;
import jp.ecuacion.splib.web.form.SplibListForm;
import jp.ecuacion.splib.web.form.SplibSearchConditionForm;
import jp.ecuacion.splib.web.service.SplibListService;
import jp.ecuacion.splib.web.util.SplibJpaServiceUtil;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
public abstract class SplibListJpaService<E extends AbstractEntity>
extends SplibListService {
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private SplibJpaServiceUtil<E> jpaServiceUtil;
    protected EntityManagerWrapper em;

    public DatetimeFormatParameters getParams() {
        return new SplibUtil().getParams(this.request);
    }

    protected LocalDate localDate(String date) {
        return date == null || date.equals("") ? null : LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public void setEntityManager(EntityManagerWrapper em) {
        this.em = em;
    }

    protected abstract SplibRepository<E, Long> getRepositoryForOptimisticLocking();

    protected abstract Object getVersion(E var1);

    protected AbstractEntity findAndOptimisticLockingCheck(String id, String versionInScreen, ActionPattern pattern) throws AppException {
        Optional optional = this.getRepositoryForOptimisticLocking().findById((Object)Long.valueOf(id));
        if (pattern == ActionPattern.DELETE && optional.isEmpty()) {
            String msg = "jp.ecuacion.splib.web.common.message.sameRecordAlreadyDeleted";
            throw new CustomizedValidationAppException(msg);
        }
        AbstractEntity e = (AbstractEntity)optional.get();
        if (pattern == ActionPattern.EDIT || pattern == ActionPattern.DELETE) {
            this.jpaServiceUtil.putNullToAuditingFields(e);
        }
        if (!versionInScreen.equals(this.getVersion(e).toString())) {
            throw new ObjectOptimisticLockingFailureException("some class", (Object)id);
        }
        return e;
    }

    @Override
    public abstract SplibListForm<? extends SplibRecord> getListForm(SplibSearchConditionForm var1) throws MultipleAppException;

    protected abstract Specification<E> getSpecs(SplibSearchConditionForm var1);

    protected Page<E> getListFormCommon(SplibSearchConditionForm searchConditionForm, JpaSpecificationExecutor<E> repository) {
        Specification<E> specs = this.getSpecs(searchConditionForm);
        searchConditionForm.setNumberOfRecordsAndAdjustCurrentPageNumger(repository.count(specs));
        return repository.findAll(specs, (Pageable)searchConditionForm.getPageRequest());
    }

    public static enum ActionPattern {
        GET_UPDATE_FORM,
        EDIT,
        DELETE;

    }
}

