/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import java.util.Map;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.splib.core.form.record.SplibRecord;
import jp.ecuacion.splib.web.advice.SplibExceptionHandlerData;
import jp.ecuacion.splib.web.controller.SplibBaseWithRecordController;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.form.SplibForm;
import jp.ecuacion.splib.web.form.SplibListForm;
import jp.ecuacion.splib.web.form.SplibSearchConditionForm;
import jp.ecuacion.splib.web.service.SplibListService;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;

public abstract class SplibListController<S extends SplibSearchConditionForm, L extends SplibListForm<? extends SplibRecord>>
extends SplibBaseWithRecordController {
    protected abstract S getNewSearchConditionForm();

    public abstract SplibListService getService();

    public SplibListController(LoginStateEnum loginState, @Nonnull String functionName, String rootRecordName) {
        super(loginState, functionName, rootRecordName);
    }

    public SplibListController(LoginStateEnum loginState, @Nonnull String functionName) {
        super(loginState, functionName, functionName);
    }

    @GetMapping(value={"search"})
    public String search(Model model, S f) throws Exception {
        S searchForm = this.getProperSearchConditionForm(model, f);
        SplibListForm<? extends SplibRecord> listForm = this.getService().getListForm((SplibSearchConditionForm)searchForm);
        listForm.setMenuName(((SplibForm)searchForm).getMenuName());
        model.addAttribute(this.functionName + "ListForm", listForm);
        return this.functionName + "List";
    }

    public String search(Model model, String menuName) throws Exception {
        S form = this.getNewSearchConditionForm();
        ((SplibForm)form).setMenuName(menuName);
        return this.search(model, form);
    }

    protected S getProperSearchConditionForm(Model model, S f) {
        String formName = this.functionName + "SearchConditionForm";
        String key = this.getSessionKey(formName, f);
        if (f != null) {
            if (((SplibSearchConditionForm)f).isRequestFromSearchForm()) {
                this.request.getSession().setAttribute(key, f);
            }
            if (this.request.getSession().getAttribute(key) == null) {
                this.request.getSession().setAttribute(key, f);
            }
        } else if (this.request.getSession().getAttribute(formName) == null) {
            throw new RuntimeException("f == null cannot be occurred.");
        }
        SplibSearchConditionForm formUsedForSearch = (SplibSearchConditionForm)this.request.getSession().getAttribute(this.getSessionKey(formName, f));
        model.addAttribute(formName, (Object)formUsedForSearch);
        return (S)formUsedForSearch;
    }

    private String getSessionKey(String formName, S f) {
        return formName + (String)(f == null || ((SplibForm)f).getMenuName() == null || ((SplibForm)f).getMenuName().equals("") ? "" : "." + ((SplibForm)f).getMenuName());
    }

    @GetMapping(value={"search"}, params={"conditionClear"})
    public String searchConditionClear(Model model, S f) throws MultipleAppException {
        String formName = this.functionName + "SearchConditionForm";
        String sessionKey = formName + (String)(((SplibForm)f).getMenuName() == null || ((SplibForm)f).getMenuName().equals("") ? "" : "." + ((SplibForm)f).getMenuName());
        this.request.getSession().setAttribute(sessionKey, null);
        return "redirect:/" + this.loginState.getCode() + "/" + this.functionName + "/search?" + this.getUrlParams(((SplibForm)f).getMenuName(), false);
    }

    @GetMapping(value={"list"}, params={"delete"})
    public String delete(Model model, L f, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepareWithMovingToListOnError((SplibForm)f, model);
        this.getService().delete((SplibListForm<? extends SplibRecord>)f, loginUser);
        return "redirect:/" + this.loginState.getCode() + "/" + this.functionName + "/search?success" + this.getUrlParams(((SplibForm)f).getMenuName(), true);
    }

    protected String getUrlParams(String menuName, boolean needsAmpersand) {
        Object additionalString = "";
        if (menuName != null && !menuName.equals("")) {
            additionalString = (needsAmpersand ? "&" : "") + "menuName=" + menuName;
        }
        return additionalString;
    }

    @GetMapping(value={"list"}, params={"showInsertForm"})
    public String showInsertForm(Model model) {
        return "redirect:/" + this.loginState.getCode() + "/" + this.functionName + "/edit?showInsertForm=";
    }

    @GetMapping(value={"list"}, params={"showUpdateForm"})
    public String showUpdateForm(Model model) {
        Map paramMap = this.request.getParameterMap();
        StringBuilder sb = new StringBuilder();
        paramMap.keySet().stream().forEach(key -> sb.append("&" + key + "=" + ((String[])paramMap.get(key))[0]));
        return "redirect:/" + this.loginState.getCode() + "/" + this.functionName + "/edit?showUpdateForm=" + sb.toString();
    }

    @Override
    protected void prepare(SplibForm form, Model model, String nextPageOnError, BindingResult result) throws InputValidationException, AppException {
        super.prepare(form, model, nextPageOnError, result);
    }

    protected void prepareWithMovingToListOnError(SplibForm form, Model model, BindingResult result) throws InputValidationException, AppException {
        SplibExceptionHandlerData info = new SplibExceptionHandlerData(this, form);
        this.request.setAttribute("ecuacion.spring.mvc.infoForErrorHandling", (Object)info);
        this.commonProc(form, model, result, false);
    }

    protected void prepareWithMovingToListOnError(SplibForm form, Model model) throws InputValidationException, AppException {
        this.prepareWithMovingToListOnError(form, model, null);
    }
}

