package jp.ecuacion.splib.web.advice;

import jp.ecuacion.splib.web.controller.SplibBaseController;
import jp.ecuacion.splib.web.controller.SplibBaseWithRecordController;
import jp.ecuacion.splib.web.form.SplibForm;

public class SplibExceptionHandlerData {

  private String nextPageOnError;

  private SplibBaseWithRecordController controller;

  private SplibForm form;

  /** validationを使用しない画面もあるため、defaultはfalseとしておく。 */
  private boolean usesSpringMvcValidationError;

  /** 遷移後の画面としてlist()を呼び出す場合に使用。 */
  public SplibExceptionHandlerData(SplibBaseWithRecordController controller, SplibForm form) {
    this(controller, form, false);
  }

  /** 遷移後の画面としてlist()を呼び出す場合に使用。 */
  public SplibExceptionHandlerData(SplibBaseWithRecordController controller, SplibForm form,
      boolean usesSpringMvcValidationError) {
    this.controller = controller;
    this.usesSpringMvcValidationError = usesSpringMvcValidationError;
    this.form = form;
  }

  /** 遷移後の画面としてnextPageOnErrorを呼び出す場合に使用。 */
  public SplibExceptionHandlerData(SplibBaseWithRecordController controller, SplibForm form,
      String nextPageOnError) {
    this(controller, form, nextPageOnError, false);
  }

  /** 遷移後の画面としてnextPageOnErrorを呼び出す場合に使用。 */
  public SplibExceptionHandlerData(SplibBaseWithRecordController controller, SplibForm form,
      String nextPageOnError, boolean usesSpringMvcValidationError) {
    this.controller = controller;
    this.nextPageOnError = nextPageOnError;
    this.usesSpringMvcValidationError = usesSpringMvcValidationError;
    this.form = form;
  }

  public String getNextPageOnError() {
    return nextPageOnError;
  }

  public void setNextPageOnError(String nextPageOnError) {
    this.nextPageOnError = nextPageOnError;
  }

  public SplibBaseController getController() {
    return controller;
  }

  public SplibForm getForm() {
    return form;
  }

  public boolean getUsesSpringMvcValidationError() {
    return usesSpringMvcValidationError;
  }
}
