/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.service;

import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import jp.ecuacion.lib.core.entity.AbstractEntity;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import jp.ecuacion.lib.jpa.dbaccess.EntityManagerWrapper;
import jp.ecuacion.splib.core.container.DatetimeFormatParameters;
import jp.ecuacion.splib.jpa.repository.SplibRepository;
import jp.ecuacion.splib.web.service.SplibEditService;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ObjectOptimisticLockingFailureException;

public abstract class SplibEditJpaService<E extends AbstractEntity>
extends SplibEditService {
    @Autowired
    private HttpServletRequest request;
    protected EntityManagerWrapper em;

    public DatetimeFormatParameters getParams() {
        return new SplibUtil().getParams(this.request);
    }

    protected LocalDate localDate(String date) {
        return date == null || date.equals("") ? null : LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public void setEntityManager(EntityManagerWrapper em) {
        this.em = em;
    }

    protected abstract SplibRepository<E, Long> getRepositoryForOptimisticLocking();

    protected abstract void putNullToAuditingFields(E var1);

    protected abstract Object getVersion(E var1);

    protected AbstractEntity findAndOptimisticLockingCheck(String id, String versionInScreen, ActionPattern pattern) throws AppException {
        Optional optional = this.getRepositoryForOptimisticLocking().findById((Object)Long.valueOf(id));
        if (pattern == ActionPattern.DELETE && optional.isEmpty()) {
            String msg = "jp.ecuacion.splib.web.common.message.sameRecordAlreadyDeleted";
            throw new CustomizedValidationAppException(msg);
        }
        AbstractEntity e = (AbstractEntity)optional.get();
        if (pattern == ActionPattern.EDIT || pattern == ActionPattern.DELETE) {
            this.putNullToAuditingFields(e);
        }
        if (!versionInScreen.equals(this.getVersion(e).toString())) {
            throw new ObjectOptimisticLockingFailureException("some class", (Object)id);
        }
        return e;
    }

    public static enum ActionPattern {
        GET_UPDATE_FORM,
        EDIT,
        DELETE;

    }
}

