/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.splib.web.controller.SplibListController;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.form.SplibEditForm;
import jp.ecuacion.splib.web.form.SplibForm;
import jp.ecuacion.splib.web.form.SplibSearchConditionForm;
import jp.ecuacion.splib.web.service.SplibListJpaService;
import jp.ecuacion.splib.web.service.SplibListService;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

public abstract class SplibListJpaController<S extends SplibSearchConditionForm, E extends SplibEditForm>
extends SplibListController<S, E> {
    @Override
    protected abstract S getNewSearchConditionForm();

    public abstract SplibListJpaService<?> getJpaService();

    @Override
    public SplibListService getService() {
        return this.getJpaService();
    }

    public SplibListJpaController(LoginStateEnum loginState, @Nonnull String functionName, String rootRecordName) {
        super(loginState, functionName, rootRecordName);
    }

    public SplibListJpaController(LoginStateEnum loginState, @Nonnull String functionName) {
        super(loginState, functionName, functionName);
    }

    @Override
    @GetMapping(value={"search"})
    public String search(Model model, S f) throws Exception {
        this.getJpaService().setEntityManager(this.dbAccessManager.getEntityManager());
        return super.search(model, f);
    }

    @Override
    @GetMapping(value={"list"}, params={"delete"})
    public String delete(Model model, E f, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepareWithMovingToListOnError((SplibForm)f, model);
        this.getJpaService().delete((SplibEditForm)f, loginUser);
        return "redirect:/" + this.loginState.getCode() + "/" + this.functionName + "/search?success" + this.getUrlParams(((SplibForm)f).getMenuName(), true);
    }

    @Override
    protected String getUrlParams(String menuName, boolean needsAmpersand) {
        Object additionalString = "";
        if (menuName != null && !menuName.equals("")) {
            additionalString = (needsAmpersand ? "&" : "") + "menuName=" + menuName;
        }
        return additionalString;
    }
}

