package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.form.SplibEditForm;
import jp.ecuacion.splib.web.form.SplibSearchConditionForm;
import jp.ecuacion.splib.web.service.SplibListJpaService;
import jp.ecuacion.splib.web.service.SplibListService;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

public abstract class SplibListJpaController
    <S extends SplibSearchConditionForm, E extends SplibEditForm>
    extends SplibListController<S, E> {

  protected abstract S getNewSearchConditionForm();
  
  public abstract SplibListJpaService<?> getJpaService();
  
  public SplibListService getService() {
    return getJpaService();
  }

  public SplibListJpaController(LoginStateEnum loginState, @Nonnull String functionName,
      String rootRecordName) {
    super(loginState, functionName, rootRecordName);
  }

  public SplibListJpaController(LoginStateEnum loginState, @Nonnull String functionName) {
    super(loginState, functionName, functionName);
  }

  @GetMapping(value = "search")
  public String search(Model model, S f) throws Exception {
    getJpaService().setEntityManager(dbAccessManager.getEntityManager());
    
    return super.search(model, f);
  }

  /**
   * 一覧からの削除処理。 delete用URLをお気に入りに入れられても困るので、本当はPostでの通信にしたいところだったが、
   * 呼び出し先を、showUpdateForm()と同じ「action」にしており、その状態でdeleteの場合のみpostに変更して投げてもspring mvcが判別つかないようで、
   * 「postは無効です」的なエラーが発生する。
   * deleteのみ別のformとするのもやりにくいし、formで持つactionをjavascriptで書き換えるのも微妙（th:actionでthymeleafが制御しているところなので）
   * なことから、GETとすることを許容する。以下の対策を行うことで、実質問題も起こらないと考えられる。 -
   * PRGを使うことで、delete中にシステムエラーでも起きない限り、delete時のURLがブラウザのURLバーには残らない
   */
  @GetMapping(value = "list", params = "delete")
  public String delete(Model model, E f, @AuthenticationPrincipal UserDetails loginUser)
      throws Exception {
    prepareWithMovingToListOnError(f, model);
    getJpaService().delete(f, loginUser);

    return "redirect:/" + loginState.getCode() + "/" + functionName + "/search?success"
        + getUrlParams(f.getMenuName(), true);
  }

  protected String getUrlParams(String menuName, boolean needsAmpersand) {
    String additionalString = "";
    if (menuName != null && !menuName.equals("")) {
      additionalString = (needsAmpersand ? "&" : "") + "menuName=" + menuName;
    }

    return additionalString;
  }
}
