package jp.ecuacion.splib.web.advice;

import jp.ecuacion.splib.web.controller.SplibBaseController;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.form.SplibGeneralForm;

public class SplibExceptionHandlerData {

  private SplibGeneralController controller;

  private SplibGeneralForm form;

  /** validationを使用しない画面もあるため、defaultはfalseとしておく。 */
  private boolean usesSpringMvcValidationError;

  /** 遷移後の画面としてlist()を呼び出す場合に使用。 */
  public SplibExceptionHandlerData(SplibGeneralController controller, SplibGeneralForm form) {
    this(controller, form, false);
  }

  /** 遷移後の画面としてlist()を呼び出す場合に使用。 */
  public SplibExceptionHandlerData(SplibGeneralController controller, SplibGeneralForm form,
      boolean usesSpringMvcValidationError) {
    this.controller = controller;
    this.usesSpringMvcValidationError = usesSpringMvcValidationError;
    this.form = form;
  }

  /** 遷移後の画面としてnextPageOnErrorを呼び出す場合に使用。 */
  public SplibExceptionHandlerData(SplibGeneralController controller, SplibGeneralForm form,
      String nextPageOnError) {
    this(controller, form, nextPageOnError, false);
  }

  /** 遷移後の画面としてnextPageOnErrorを呼び出す場合に使用。 */
  public SplibExceptionHandlerData(SplibGeneralController controller, SplibGeneralForm form,
      String nextPageOnError, boolean usesSpringMvcValidationError) {
    this.controller = controller;
    this.usesSpringMvcValidationError = usesSpringMvcValidationError;
    this.form = form;
  }

  public SplibBaseController getController() {
    return controller;
  }

  public SplibGeneralForm getForm() {
    return form;
  }

  public boolean getUsesSpringMvcValidationError() {
    return usesSpringMvcValidationError;
  }
}
