/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.service;

import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import jp.ecuacion.lib.core.entity.AbstractEntity;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.jpa.dbaccess.EntityManagerWrapper;
import jp.ecuacion.splib.core.container.DatetimeFormatParameters;
import jp.ecuacion.splib.core.form.record.SplibRecord;
import jp.ecuacion.splib.web.form.SplibListForm;
import jp.ecuacion.splib.web.form.SplibSearchForm;
import jp.ecuacion.splib.web.service.SplibJpaServiceInterface;
import jp.ecuacion.splib.web.service.SplibSearchListService;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
public abstract class SplibSearchListJpaService<E extends AbstractEntity>
extends SplibSearchListService
implements SplibJpaServiceInterface<E> {
    @Autowired
    private HttpServletRequest request;
    protected EntityManagerWrapper em;

    @Override
    public DatetimeFormatParameters getParams() {
        return new SplibUtil().getParams(this.request);
    }

    @Override
    protected LocalDate localDate(String date) {
        return date == null || date.equals("") ? null : LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public void setEntityManager(EntityManagerWrapper em) {
        this.em = em;
    }

    @Override
    public abstract SplibListForm<? extends SplibRecord> getListForm(SplibSearchForm var1) throws MultipleAppException;

    protected abstract Specification<E> getSpecs(SplibSearchForm var1);

    protected Page<E> getListFormCommon(SplibSearchForm searchForm, JpaSpecificationExecutor<E> repository) {
        Specification<E> specs = this.getSpecs(searchForm);
        searchForm.setNumberOfRecordsAndAdjustCurrentPageNumger(repository.count(specs));
        return repository.findAll(specs, (Pageable)searchForm.getPageRequest());
    }

    public static enum ActionPattern {
        GET_UPDATE_FORM,
        EDIT,
        DELETE;

    }
}

