/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import java.util.Set;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import jp.ecuacion.splib.web.advice.SplibExceptionHandlerData;
import jp.ecuacion.splib.web.bean.RedirectUrlOnAppExceptionBean;
import jp.ecuacion.splib.web.bean.RedirectUrlOnSuccessBean;
import jp.ecuacion.splib.web.bean.RedirectUrlOnSuccessPageBean;
import jp.ecuacion.splib.web.bean.RedirectUrlOnSuccessPathBean;
import jp.ecuacion.splib.web.controller.SplibBaseController;
import jp.ecuacion.splib.web.controller.SplibSearchListJpaController;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;

public abstract class SplibGeneralController
extends SplibBaseController {
    protected String functionName;
    @Nonnull
    protected String rootRecordName;
    protected RedirectUrlOnAppExceptionBean redirectUrlOnAppExceptionBean;

    public SplibGeneralController(LoginStateEnum loginState, @Nonnull String functionName) {
        super(loginState);
        this.functionName = functionName;
        this.rootRecordName = functionName;
    }

    public SplibGeneralController(LoginStateEnum loginState, @Nonnull String functionName, String rootRecordName) {
        this(loginState, functionName);
        this.rootRecordName = rootRecordName == null ? "" : rootRecordName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getRootRecordName() {
        return this.rootRecordName;
    }

    public RedirectUrlOnAppExceptionBean getRedirectUrlOnAppExceptionBean() {
        return this.redirectUrlOnAppExceptionBean;
    }

    protected String getActionSuccessRedirectString(RedirectUrlOnSuccessBean redirectUrlBean) {
        if (redirectUrlBean instanceof RedirectUrlOnSuccessPageBean) {
            return ((RedirectUrlOnSuccessPageBean)redirectUrlBean).getUrl(this.loginState, this.functionName);
        }
        if (redirectUrlBean instanceof RedirectUrlOnSuccessPathBean) {
            return ((RedirectUrlOnSuccessPathBean)redirectUrlBean).getUrl();
        }
        throw new RuntimeException("RedirectUrlBean\u304c\u60f3\u5b9a\u5916\u306e\u5024\u3067\u3059\u3002" + redirectUrlBean);
    }

    public String getDefaultHtmlFileName() {
        return this.functionName;
    }

    public String getDefaultSuccessPage() {
        return "page";
    }

    public String getDefaultErrorPage() {
        return "page";
    }

    @ModelAttribute
    private void setCommonParamsToModel(Model model) {
        model.addAttribute("functionName", (Object)this.functionName);
        model.addAttribute("rootRecordName", (Object)this.rootRecordName);
    }

    protected void commonProc(SplibGeneralForm form, Model model, BindingResult result, boolean needsValidationCheck) throws InputValidationException, AppException {
        this.tokenCheck();
        if (needsValidationCheck) {
            this.validationCheck(form, result);
        }
    }

    protected void tokenCheck() throws CustomizedValidationAppException {
        String tokenFromHtml = this.request.getParameter("transactionToken");
        Set tokenSet = (Set)this.request.getSession().getAttribute("transactionToken");
        if (tokenSet != null && tokenFromHtml != null) {
            if (!tokenSet.contains(tokenFromHtml)) {
                if (this instanceof SplibSearchListJpaController) {
                    // empty if block
                }
                String msgId = "jp.ecuacion.splib.web.common.message.tokenInvalidate";
                throw new CustomizedValidationAppException(msgId);
            }
            tokenSet.remove(tokenFromHtml);
        }
    }

    private void validationCheck(SplibGeneralForm form, BindingResult result) throws InputValidationException {
        boolean hasNotEmptyError = false;
        hasNotEmptyError = form.hasNotEmptyError();
        if (hasNotEmptyError || result != null && result.hasErrors()) {
            throw new InputValidationException(form);
        }
    }

    protected void prepare(SplibGeneralForm form, Model model) throws InputValidationException, AppException {
        this.prepare(form, model, null, null, false);
    }

    protected void prepare(SplibGeneralForm form, Model model, String nextPageOnError) throws InputValidationException, AppException {
        this.prepare(form, model, nextPageOnError, null, false);
    }

    protected void prepare(SplibGeneralForm form, Model model, BindingResult result) throws InputValidationException, AppException {
        this.prepare(form, model, null, result, true);
    }

    protected void prepare(SplibGeneralForm form, Model model, String nextPageOnError, BindingResult result) throws InputValidationException, AppException {
        this.prepare(form, model, nextPageOnError, result, true);
    }

    private void prepare(SplibGeneralForm form, Model model, String nextPageOnError, BindingResult result, boolean needsValidationCheck) throws InputValidationException, AppException {
        model.addAttribute(this.functionName + "Form", (Object)form);
        SplibExceptionHandlerData info = new SplibExceptionHandlerData(this, form, nextPageOnError);
        this.request.setAttribute("ecuacion.spring.mvc.infoForErrorHandling", (Object)info);
        this.commonProc(form, model, result, needsValidationCheck);
    }
}

