/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import org.springframework.stereotype.Component;

@Component(value="optUtil")
public class SplibOptionUtil {
    private HttpServletRequest request;

    public SplibOptionUtil(HttpServletRequest request) {
        this.request = request;
    }

    public String getDeleteConfirmMessage(String itemDisplayedOnDelete) {
        String commonItem;
        while (((String)itemDisplayedOnDelete).split("\\.").length > 2) {
            itemDisplayedOnDelete = ((String)itemDisplayedOnDelete).substring(((String)itemDisplayedOnDelete).indexOf(".") + 1);
        }
        if (!PropertyFileUtil.hasFieldName((String)itemDisplayedOnDelete) && PropertyFileUtil.hasFieldName((String)(commonItem = "SystemCommonEntity." + ((String)itemDisplayedOnDelete).substring(((String)itemDisplayedOnDelete).lastIndexOf(".") + 1)))) {
            itemDisplayedOnDelete = commonItem;
        }
        String fieldName = PropertyFileUtil.getFieldName((Locale)this.request.getLocale(), (String)itemDisplayedOnDelete);
        return PropertyFileUtil.getMsg((Locale)this.request.getLocale(), (String)"jp.ecuacion.splib.web.common.message.deleteConfirmation", (String[])new String[]{fieldName});
    }

    private Map<String, String> optionMap(String optionCsv) {
        String[] options;
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        if (optionCsv == null || optionCsv.equals("")) {
            return rtnMap;
        }
        String key = null;
        String value = null;
        for (String option : options = optionCsv.split(",")) {
            if (option.contains("=")) {
                key = option.substring(0, option.indexOf("="));
                value = option.substring(option.indexOf("=") + 1);
            } else {
                key = option;
            }
            String lowerCaseKey = key.toLowerCase();
            rtnMap.put(lowerCaseKey, value);
        }
        return rtnMap;
    }

    private boolean keyExistenceCheck(String options, String key) {
        return this.optionMap(options).containsKey(key.toLowerCase());
    }

    private String getValue(String options, String key) {
        return this.optionMap(options).get(key.toLowerCase());
    }

    private String defaultIfKeyNotExist(String options, String key, String defaultValue) {
        if (this.keyExistenceCheck(options, key)) {
            return this.getValue(options, key);
        }
        return Integer.valueOf(defaultValue).toString();
    }

    public boolean isReadOnly(String options) {
        return this.keyExistenceCheck(options, "readonly");
    }

    public boolean isDisabled(String options) {
        return this.keyExistenceCheck(options, "disabled");
    }

    public boolean isDeleted(String options) {
        return this.keyExistenceCheck(options, "deleted");
    }

    public boolean isForSwitch(String options) {
        return this.keyExistenceCheck(options, "forSwitch");
    }

    public boolean needsEmptyOption(String options) {
        return !this.keyExistenceCheck(options, "noEmptyOption");
    }

    public boolean submitsOnChange(String options) {
        return this.keyExistenceCheck(options, "submitOnChange");
    }

    public boolean needsOnclickJs(String options) {
        return this.keyExistenceCheck(options, "onClickJs");
    }

    public boolean hasLinkUrl(String options) {
        return this.keyExistenceCheck(options, "linkUrl");
    }

    public String getLinkUrl(String options) {
        return this.getValue(options, "linkUrl");
    }

    public String rows(String options) {
        return this.defaultIfKeyNotExist(options, "rows", "1");
    }

    public String cols(String options) {
        return this.defaultIfKeyNotExist(options, "cols", "1");
    }

    public boolean hasThSortable(String options) {
        return this.keyExistenceCheck(options, "thSortable");
    }

    public boolean isWidthFull(String options) {
        return this.widthCheck(options, "full");
    }

    public boolean isWidthHalf(String options) {
        return this.widthCheck(options, "half");
    }

    private boolean widthCheck(String options, String value) {
        String key = "width";
        if (!this.keyExistenceCheck(options, key)) {
            return false;
        }
        return this.getValue(options, key).equalsIgnoreCase(value);
    }
}

