package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.splib.core.form.record.SplibRecord;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.form.SplibListForm;
import jp.ecuacion.splib.web.form.SplibSearchForm;
import jp.ecuacion.splib.web.service.SplibListJpaService;
import jp.ecuacion.splib.web.service.SplibListService;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

public abstract class SplibListJpaController
    <S extends SplibSearchForm, L extends SplibListForm<? extends SplibRecord>>
    extends SplibListController<S, L> {
  
  public abstract SplibListJpaService<?> getJpaService();
  
  public SplibListService getService() {
    return getJpaService();
  }

  public SplibListJpaController(LoginStateEnum loginState, @Nonnull String functionName,
      String rootRecordName) {
    super(loginState, functionName, rootRecordName);
  }

  public SplibListJpaController(LoginStateEnum loginState, @Nonnull String functionName) {
    super(loginState, functionName, functionName);
  }

  @GetMapping(value = "search")
  public String search(Model model, S f) throws Exception {
    getJpaService().setEntityManager(dbAccessManager.getEntityManager());
    
    return super.search(model, f);
  }
}
