package jp.ecuacion.splib.web.bean;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;

public abstract class RedirectUrlBean {

  private final Map<String, String> paramMap;

  public RedirectUrlBean(Map<String, String> paramMap) {
    this.paramMap = paramMap;
  }

  public RedirectUrlBean(String paramKey, String paramValue) {
    paramMap = new HashMap<>();

    Objects.requireNonNull(paramKey);
    Objects.requireNonNull(paramValue);

    paramMap.put(paramKey, paramValue);
  }

  public RedirectUrlBean(String[][] paramPairs) {
    paramMap = new HashMap<>();

    Objects.requireNonNull(paramPairs);

    for (int i = 0; i < paramPairs.length; i++) {
      Objects.requireNonNull(paramPairs[i]);

      String[] paramPair = paramPairs[i];
      Objects.requireNonNull(paramPair);
      if (paramPair.length != 2) {
        throw new RuntimeException("paramPairs[i].length must be 2.");
      }

      paramMap.put(paramPair[0], paramPair[1]);
    }
  }

  public Map<String, String> getParamMap() {
    return paramMap;
  }

  protected String getParamsString() {
    boolean is1st = true;
    StringBuilder sb = new StringBuilder();
    for (Entry<String, String> entry : paramMap.entrySet()) {
      if (is1st) {
        is1st = false;
        sb.append("?");

      } else {
        sb.append("&");
      }

      sb.append(entry.getKey() + "=" + entry.getValue());
    }

    return sb.toString();
  }
}
