/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.advice;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.AppWarningException;
import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.util.BeanValidationUtil;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.splib.web.advice.SplibExceptionHandlerActionOnThrowable;
import jp.ecuacion.splib.web.advice.SplibExceptionHandlerData;
import jp.ecuacion.splib.web.bean.RequestResultBean;
import jp.ecuacion.splib.web.controller.SplibBaseWithRecordController;
import jp.ecuacion.splib.web.controller.SplibEditController;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.controller.SplibListController;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.form.SplibEditForm;
import jp.ecuacion.splib.web.form.record.RecordInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatusCode;
import org.springframework.ui.Model;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

public abstract class SplibExceptionHandlerNoJpa {
    public static final String INFO_FOR_ERROR_HANDLING = "ecuacion.spring.mvc.infoForErrorHandling";
    private LogUtil util = new LogUtil();
    @Autowired
    HttpServletRequest request;
    @Autowired
    SplibExceptionHandlerActionOnThrowable actionOnThrowable;

    protected SplibExceptionHandlerData getInfo() {
        return (SplibExceptionHandlerData)this.request.getAttribute(INFO_FOR_ERROR_HANDLING);
    }

    private Model getModel() {
        return (Model)this.request.getAttribute("REQUEST_KEY_MODEL");
    }

    private String addFieldName(String message, String itemName) {
        return this.addFieldNames(message, new String[]{itemName});
    }

    private String addFieldNames(String message, String[] itemNames) {
        if (message.contains("{0}")) {
            message = MessageFormat.format(message, this.getItemNames(itemNames));
        }
        return message;
    }

    private String getItemNames(String[] itemNames) {
        StringBuilder sb = new StringBuilder();
        String prependParenthesis = PropertyFileUtil.getMsg((Locale)this.request.getLocale(), (String)"jp.ecuacion.splib.web.common.message.itemName.prependParenthesis");
        String appendParenthesis = PropertyFileUtil.getMsg((Locale)this.request.getLocale(), (String)"jp.ecuacion.splib.web.common.message.itemName.appendParenthesis");
        String separator = PropertyFileUtil.getMsg((Locale)this.request.getLocale(), (String)"jp.ecuacion.splib.web.common.message.itemName.separator");
        boolean is1stTime = true;
        for (String itemName : itemNames) {
            if (PropertyFileUtil.hasFieldName((String)itemName)) {
                itemName = PropertyFileUtil.getFieldName((Locale)this.request.getLocale(), (String)itemName);
            }
            if (is1stTime) {
                is1stTime = false;
            } else {
                sb.append(separator);
            }
            sb.append(prependParenthesis + itemName + appendParenthesis);
        }
        return sb.toString();
    }

    @ExceptionHandler(value={AppWarningException.class})
    public ModelAndView handleAppWarningException(AppWarningException exception) throws MultipleAppException {
        SplibExceptionHandlerData info = this.getInfo();
        RequestResultBean requestResult = (RequestResultBean)this.getModel().getAttribute("result");
        requestResult.setWarnMessage(exception.getMessageId(), PropertyFileUtil.getMsg((Locale)this.request.getLocale(), (String)exception.getMessageId(), (String[])exception.getMessageArgs()), exception.getButtonId());
        return this.common(info);
    }

    @ExceptionHandler(value={AppException.class})
    public ModelAndView handleAppException(AppException exception) throws MultipleAppException {
        SplibExceptionHandlerData info = this.getInfo();
        RequestResultBean requestResult = (RequestResultBean)this.getModel().getAttribute("result");
        ArrayList<SingleAppException> exList = new ArrayList<SingleAppException>();
        if (exception instanceof MultipleAppException) {
            for (SingleAppException appEx : ((MultipleAppException)exception).getList()) {
                exList.add(appEx);
            }
        } else {
            exList.add((SingleAppException)exception);
        }
        for (SingleAppException saex : exList) {
            String[] fields = null;
            if (saex instanceof CustomizedValidationAppException && this.getInfo().getController() instanceof SplibBaseWithRecordController) {
                CustomizedValidationAppException ex = (CustomizedValidationAppException)saex;
                fields = ex.getFields() == null ? new String[]{} : ex.getFields().getFields();
                SplibBaseWithRecordController controller = (SplibBaseWithRecordController)info.getController();
                ArrayList<Object> modifiedFieldList = new ArrayList<Object>();
                Objects.requireNonNull(fields);
                String prefix = controller.getRootRecordName() + ".";
                for (String field : fields) {
                    modifiedFieldList.add(field.startsWith(prefix) ? field : prefix + field);
                }
                fields = modifiedFieldList.toArray(new String[modifiedFieldList.size()]);
            }
            for (String message : new ExceptionUtil().getAppExceptionMessageList((AppException)saex, this.request.getLocale())) {
                message = this.addFieldNames(message, fields);
                requestResult.setErrorMessage(message, fields);
            }
        }
        return this.common(info);
    }

    @ExceptionHandler(value={InputValidationException.class})
    public ModelAndView handleInputValidationException(InputValidationException exception) throws MultipleAppException {
        SplibExceptionHandlerData info = this.getInfo();
        RequestResultBean requestResult = (RequestResultBean)this.getModel().getAttribute("result");
        List<ValidationErrorInfoBean> errorList = new BeanValidationUtil().validate((Object)exception.getForm(), this.request.getLocale()).stream().map(cv -> new ValidationErrorInfoBean((ConstraintViolation<?>)cv)).collect(Collectors.toList());
        errorList.addAll(exception.getForm().validateNotEmpty(this.request.getLocale()).stream().collect(Collectors.toList()));
        errorList = errorList.stream().sorted(this.getComparator()).collect(Collectors.toList());
        this.removeDuplicatedValidators(errorList);
        for (ValidationErrorInfoBean cv2 : errorList) {
            String itemId;
            String message = cv2.getMessage();
            String itemName = itemId = cv2.getPropertyPath().toString();
            itemName = ((RecordInterface)exception.getForm().getRootRecord()).getLabelItemName(exception.getForm().getRootRecordField().getName(), itemName);
            message = this.addFieldName(message, itemName);
            requestResult.setErrorMessage(message, itemId);
        }
        if (exception.getForm() instanceof SplibEditForm) {
            ((SplibEditController)info.getController()).getService().prepareEditForm((SplibEditForm)exception.getForm());
        }
        return this.common(info);
    }

    private void removeDuplicatedValidators(List<ValidationErrorInfoBean> cvList) {
        HashMap duplicateCheckMap = new HashMap();
        HashSet<String> keySetWithNotEmpty = new HashSet<String>();
        for (ValidationErrorInfoBean cv : cvList) {
            String key = cv.getPropertyPath().toString();
            if (duplicateCheckMap.get(key) == null) {
                duplicateCheckMap.put(key, new HashSet());
            }
            ((Set)duplicateCheckMap.get(key)).add(cv);
            if (!this.isNotEmptyValidator(cv)) continue;
            keySetWithNotEmpty.add(key);
        }
        for (String key : keySetWithNotEmpty) {
            for (ValidationErrorInfoBean cv : (Set)duplicateCheckMap.get(key)) {
                if (this.isNotEmptyValidator(cv)) continue;
                cvList.remove(cv);
            }
        }
    }

    private boolean isNotEmptyValidator(ValidationErrorInfoBean cv) {
        String validatorClass = cv.getValidatorClass();
        return validatorClass.endsWith("NotEmpty") || validatorClass.endsWith("NotEmptyIfValid");
    }

    private Comparator<ValidationErrorInfoBean> getComparator() {
        return new Comparator<ValidationErrorInfoBean>(){

            @Override
            public int compare(ValidationErrorInfoBean f1, ValidationErrorInfoBean f2) {
                int result = f1.getPropertyPath().toString().compareTo(f2.getPropertyPath().toString());
                if (result != 0) {
                    return result;
                }
                result = f1.getValidatorClass().compareTo(f2.getValidatorClass());
                if (result != 0) {
                    return result;
                }
                String s1 = f1.getAnnotationDescriptionString();
                String s2 = f2.getAnnotationDescriptionString();
                return s1.compareTo(s2);
            }
        };
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public String handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException exception, Model model) throws CustomizedValidationAppException {
        this.util.logErr((Throwable)exception, this.request.getLocale());
        this.actionOnThrowable.execute((Throwable)exception);
        return "redirect:/public/login?error";
    }

    @ExceptionHandler(value={Throwable.class})
    public ModelAndView handleThrowable(Throwable exception) {
        this.util.logErr(exception, this.request.getLocale());
        this.actionOnThrowable.execute(exception);
        return new ModelAndView("error", this.getModel() == null ? null : this.getModel().asMap(), HttpStatusCode.valueOf((int)500));
    }

    private ModelAndView common(SplibExceptionHandlerData info) throws MultipleAppException {
        String returnPage = null;
        Model model = this.getModel();
        if (info.getController() instanceof SplibListController && info.getNextPageOnError() == null) {
            returnPage = ((SplibListController)info.getController()).search(model, info.getForm().getMenuName());
        } else {
            returnPage = info.getNextPageOnError();
            if (returnPage == null && info.getController() instanceof SplibGeneralController) {
                SplibGeneralController controller = (SplibGeneralController)info.getController();
                returnPage = controller.getFunctionName();
            }
        }
        return new ModelAndView(returnPage, model.asMap());
    }

    public static class ValidationErrorInfoBean {
        private String message;
        private String propertyPath;
        private String validatorClass;
        private String annotationDescriptionString;

        public ValidationErrorInfoBean(String message, String propertyPath, String validatorClass) {
            this.message = message;
            this.propertyPath = propertyPath;
            this.validatorClass = validatorClass;
            this.annotationDescriptionString = "";
        }

        public ValidationErrorInfoBean(ConstraintViolation<?> cv) {
            this.message = cv.getMessage();
            this.propertyPath = cv.getPropertyPath().toString();
            this.validatorClass = cv.getConstraintDescriptor().getAnnotation().annotationType().getName();
            this.annotationDescriptionString = cv.getConstraintDescriptor().getAnnotation().toString();
        }

        public String getMessage() {
            return this.message;
        }

        public String getPropertyPath() {
            return this.propertyPath;
        }

        public String getValidatorClass() {
            return this.validatorClass;
        }

        public String getAnnotationDescriptionString() {
            return this.annotationDescriptionString;
        }
    }
}

