/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.config;

import java.util.Arrays;
import java.util.List;
import org.springframework.boot.autoconfigure.security.servlet.PathRequest;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public abstract class SplibWebSecurityConfig {
    protected PasswordEncoder passwordEncoder = new BCryptPasswordEncoder();

    protected abstract String getDefaultSuccessUrl();

    protected abstract String getUrlWithLoginNeededPageAccessed();

    protected abstract List<AuthorizationBean> getRoleInfo();

    protected abstract List<AuthorizationBean> getAuthorityInfo();

    @Bean
    PasswordEncoder passwordEncoder() {
        return this.passwordEncoder;
    }

    @Bean
    MvcRequestMatcher.Builder mvc(HandlerMappingIntrospector introspector) {
        return new MvcRequestMatcher.Builder(introspector);
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http, MvcRequestMatcher.Builder mvc) throws Exception {
        http.httpBasic().disable();
        ((FormLoginConfigurer)((FormLoginConfigurer)http.formLogin().loginPage(this.getUrlWithLoginNeededPageAccessed()).loginProcessingUrl("/public/login/action")).usernameParameter("login.username").passwordParameter("login.password").defaultSuccessUrl(this.getDefaultSuccessUrl(), true)).failureUrl("/public/login/page?error");
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.authorizeHttpRequests().requestMatchers(new RequestMatcher[]{PathRequest.toStaticResources().atCommonLocations()})).permitAll().requestMatchers(new RequestMatcher[]{mvc.pattern("/public/**")})).permitAll().requestMatchers(new RequestMatcher[]{mvc.pattern("/ecuacion/public/**")})).permitAll();
        if (this.getRoleInfo() != null) {
            for (AuthorizationBean bean : this.getRoleInfo()) {
                List<MvcRequestMatcher> list = Arrays.asList(bean.requestMatchers).stream().map(str -> mvc.pattern(str)).toList();
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.authorizeHttpRequests().requestMatchers((RequestMatcher[])list.toArray(new MvcRequestMatcher[list.size()]))).hasAnyRole(bean.roleOrAuthority);
            }
        }
        if (this.getAuthorityInfo() != null) {
            for (AuthorizationBean bean : this.getAuthorityInfo()) {
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.authorizeHttpRequests().requestMatchers(bean.requestMatchers)).hasAnyAuthority(bean.roleOrAuthority);
            }
        }
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.authorizeHttpRequests().anyRequest()).authenticated();
        http.logout().logoutUrl("/public/logout").logoutSuccessUrl("/public/login/page?logoutDone");
        http.exceptionHandling().accessDeniedPage("/public/login/page?accessDenied");
        return (SecurityFilterChain)http.build();
    }

    public static class AuthorizationBean {
        private String[] requestMatchers;
        private String[] roleOrAuthority;

        public AuthorizationBean() {
        }

        public AuthorizationBean(String requestMatchers, String roleOrAuthority) {
            this.requestMatchers = new String[]{requestMatchers};
            this.roleOrAuthority = new String[]{roleOrAuthority};
        }

        public AuthorizationBean(String[] requestMatchers, String roleOrAuthority) {
            this.roleOrAuthority = new String[]{roleOrAuthority};
            this.requestMatchers = requestMatchers;
        }

        public AuthorizationBean(String[] requestMatchers, String[] roleOrAuthority) {
            this.roleOrAuthority = roleOrAuthority;
            this.requestMatchers = requestMatchers;
        }

        public String[] getRequestMatchers() {
            return this.requestMatchers;
        }

        public void setRequestMatchers(String[] requestMatchers) {
            this.requestMatchers = requestMatchers;
        }

        public String[] getRoleOrAuthority() {
            return this.roleOrAuthority;
        }

        public void setRoleOrAuthority(String[] roleOrAuthority) {
            this.roleOrAuthority = roleOrAuthority;
        }
    }
}

