package jp.ecuacion.splib.web.util;

import java.util.Locale;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import org.springframework.stereotype.Component;

/**
 * thymeleaf側から呼ばれる想定のクラス。localeを加味したメッセージ表示を実施。
 * 裏ではPropertyFileUtilを呼び出しているのみ。PropertyFileUtilの機能が使える分#{...} より協力。
 * ただし、#{...}で問題ない部分はそれを使っても問題なし。
 */
@Component("msgUtil")
public class SplibMessageUtil {
  
  public SplibMessageUtil() {
  }
  
  public String get(Locale locale, String id) {
    return PropertyFileUtil.getMsg(locale, id);
  }
}
