/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.form;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.splib.web.form.PagerInfo;
import jp.ecuacion.splib.web.form.SplibForm;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

public abstract class SplibSearchConditionForm
extends SplibForm {
    public static final String DIRECTION_ASC = "asc";
    public static final String DIRECTION_DESC = "desc";
    private boolean requestFromSearchForm;
    protected String sortItem = this.getDefaultSortItem();
    protected String direction = this.getDefaultDirection();
    protected Integer page = 0;
    protected Integer recordsInScreen = 5;
    protected Integer numberOfRecords;

    protected abstract String getDefaultSortItem();

    protected String getDefaultDirection() {
        return DIRECTION_ASC;
    }

    public boolean isRequestFromSearchForm() {
        return this.requestFromSearchForm;
    }

    public void setRequestFromSearchForm(boolean requestFromSearchForm) {
        this.requestFromSearchForm = requestFromSearchForm;
    }

    public String getSortItem() {
        return this.sortItem;
    }

    public String getSortItemWithDefault() {
        return this.sortItem == null ? this.getDefaultSortItem() : this.sortItem;
    }

    public void setSortItem(String sortItem) {
        this.sortItem = sortItem;
    }

    public String getDirection() {
        return this.direction;
    }

    public Sort.Direction getDirectionEnum() {
        return this.direction != null && this.getDirection().equals(DIRECTION_DESC) ? Sort.Direction.DESC : Sort.Direction.ASC;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String nextDirection(String sortItem) {
        if (this.sortItem != null && this.sortItem.equals(sortItem) && this.getDirection().equals(DIRECTION_ASC)) {
            return DIRECTION_DESC;
        }
        return DIRECTION_ASC;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getRecordsInScreen() {
        return this.recordsInScreen;
    }

    public void setRecordsInScreen(Integer recordsInScreen) {
        this.recordsInScreen = recordsInScreen;
    }

    public Integer getNumberOfRecords() {
        return this.numberOfRecords;
    }

    public void setNumberOfRecordsAndAdjustCurrentPageNumger(Long numberOfRecords) {
        this.numberOfRecords = Long.valueOf(numberOfRecords).intValue();
        this.changePageIfThePageNumberExceedsTheLast();
    }

    private void changePageIfThePageNumberExceedsTheLast() {
        int lastPageFromRecordCount = this.numberOfRecords / this.recordsInScreen + (this.numberOfRecords % this.recordsInScreen > 0 ? 1 : 0) - 1;
        if (lastPageFromRecordCount < 0) {
            lastPageFromRecordCount = 0;
        }
        if (this.getPage() > lastPageFromRecordCount) {
            this.page = lastPageFromRecordCount;
        }
    }

    public PageRequest getPageRequest() {
        return PageRequest.of((int)this.getPage(), (int)this.getRecordsInScreen(), (Sort)Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(this.getDirectionEnum(), this.getSortItemWithDefault())}));
    }

    public List<PagerInfo> getPagerInfoList(Locale locale) {
        boolean needsSandwichedNumber;
        String labelPrev = PropertyFileUtil.getMsg((Locale)locale, (String)"jp.ecuacion.splib.web.tool.common.label.prev");
        String labelNext = PropertyFileUtil.getMsg((Locale)locale, (String)"jp.ecuacion.splib.web.tool.common.label.next");
        ArrayList<PagerInfo> rtnList = new ArrayList<PagerInfo>();
        PageRequest pageRequest = this.getPageRequest();
        if (this.numberOfRecords <= this.recordsInScreen) {
            return rtnList;
        }
        rtnList.add(pageRequest.getPageNumber() > 0 ? new PagerInfo(labelPrev, false, pageRequest.getPageNumber() - 1) : new PagerInfo(labelPrev));
        rtnList.add(new PagerInfo("1", pageRequest.getPageNumber() == 0, 0));
        if (pageRequest.getPageNumber() == 0 && this.numberOfRecords > this.recordsInScreen * 2 || pageRequest.getPageNumber() >= 2) {
            rtnList.add(new PagerInfo("..."));
        }
        int lastPageFromRecordCount = this.numberOfRecords / this.recordsInScreen + (this.numberOfRecords % this.recordsInScreen > 0 ? 1 : 0) - 1;
        boolean bl = needsSandwichedNumber = pageRequest.getPageNumber() != 0 && pageRequest.getPageNumber() < lastPageFromRecordCount;
        if (needsSandwichedNumber) {
            rtnList.add(new PagerInfo(Integer.valueOf(pageRequest.getPageNumber() + 1).toString(), true, pageRequest.getPageNumber()));
        }
        if (pageRequest.getPageNumber() <= lastPageFromRecordCount - 2 && needsSandwichedNumber) {
            rtnList.add(new PagerInfo("..."));
        }
        int lastPage = lastPageFromRecordCount > pageRequest.getPageNumber() ? lastPageFromRecordCount : pageRequest.getPageNumber();
        rtnList.add(new PagerInfo(Integer.valueOf(lastPage + 1).toString(), pageRequest.getPageNumber() == lastPage, lastPage));
        rtnList.add(pageRequest.getPageNumber() != lastPage ? new PagerInfo(labelNext, false, pageRequest.getPageNumber() + 1) : new PagerInfo(labelNext));
        return rtnList;
    }

    public String getLinesInScreen() {
        if (this.numberOfRecords == 0) {
            return "";
        }
        if (this.numberOfRecords / this.recordsInScreen < this.page) {
            return "( - / " + this.numberOfRecords + ")";
        }
        int min = this.page * this.recordsInScreen + 1;
        int normalMax = (this.page + 1) * this.recordsInScreen;
        int max = normalMax > this.numberOfRecords ? this.numberOfRecords : normalMax;
        return "( " + min + " - " + max + " / " + this.numberOfRecords + " )";
    }
}

