package jp.ecuacion.splib.web.controller;

import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.form.LoginForm;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope("prototype")
@RequestMapping("/public/login")
public class LoginController extends SplibGeneralController<LoginForm> {
  
  public LoginController() {
    super(LoginStateEnum.PUBLIC, "login", "login");
  }

  /**
   * Session Timeout状態で、ログインボタンや他のPOST系ボタンを押す場合、session timeoutで弾かれ
   * /public/login/accessDeined にredirectされるが、そのredirectもPOSTで行われるため
   * 本処理にPOSTで入ってくることがある。それを考慮し@RequestMappingにしておく。
   */
  @RequestMapping("page")
  public String page(Model model) throws CustomizedValidationAppException {
    model.addAttribute("loginForm", new LoginForm());
    return "login";
  }
}
