package jp.ecuacion.splib.web.controller;

import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.form.ConfigForm;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope("prototype")
@RequestMapping("/ecuacion/public/config")
public class ConfigController extends SplibGeneralController<ConfigForm> {
  
  public ConfigController() {
    super(LoginStateEnum.ECUACION_PUBLIC, "config", "config");
  }

  @GetMapping("page")
  public String page(Model model) {
    model.addAttribute("configForm", new ConfigForm());
    return "config";
  }
}
