package jp.ecuacion.splib.web.advice;

import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

/** SplibExceptionHandlerNoJpaに、jpa独自の例外処理を追加したクラス。JPAを使用している場合はこちらを継承。 */
public abstract class SplibExceptionHandlerJpa extends SplibExceptionHandlerNoJpa {

  /**
   * 楽観的排他制御の処理。 画面表示〜ボタン押下の間にレコード更新された場合は、手動でチェックなので直接CustomizedValidationAppExceptionを投げても良いのだが、
   * 複数sessionで同一レコードを同時更新した場合（service内の処理内でのselectからupdateの間に別sessionがselect〜updateを完了）は
   * JPAが自動でObjectOptimisticLockingFailureExceptionを投げてくるので、それも同様に処理できるよう楽観的排他制御エラーは
   * ObjectOptimisticLockingFailureExceptionで統一しておく。
   */
  @ExceptionHandler({ObjectOptimisticLockingFailureException.class})
  public ModelAndView handleObjectOptimisticLockingFailureException(
      ObjectOptimisticLockingFailureException exception) throws MultipleAppException {
    // 通常のチェックエラー扱いとする
    return handleAppException(new CustomizedValidationAppException(
        "jp.ecuacion.splib.web.common.message.optimisticLocking"));
  }

  @ExceptionHandler({PessimisticLockingFailureException.class})
  public ModelAndView handlePessimisticLockingFailureException(
      PessimisticLockingFailureException exception) throws MultipleAppException {
    // 通常のチェックエラー扱いとする
    return handleAppException(new CustomizedValidationAppException(
        "jp.ecuacion.splib.web.common.message.pessimisticLocking"));
  }
}
