/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller.internal;

import jakarta.annotation.Nonnull;
import java.util.Set;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import jp.ecuacion.splib.web.advice.SplibExceptionHandlerData;
import jp.ecuacion.splib.web.controller.SplibBaseController;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.form.SplibEditForm;
import jp.ecuacion.splib.web.form.SplibForm;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;

public abstract class SplibBaseWithRecordController
extends SplibBaseController {
    @Nonnull
    protected String rootRecordName;

    public SplibBaseWithRecordController(LoginStateEnum loginState, String functionName, String rootRecordName) {
        super(loginState, functionName);
        this.rootRecordName = rootRecordName == null ? "" : rootRecordName;
    }

    public String getRootRecordName() {
        return this.rootRecordName;
    }

    @ModelAttribute
    private void setCommonParamsToModel(Model model) {
        model.addAttribute("rootRecordName", (Object)this.rootRecordName);
    }

    protected void commonProc(SplibForm form, Model model, BindingResult result, boolean needsValidationCheck) throws InputValidationException, AppException {
        String tokenFromHtml = this.request.getParameter("transactionToken");
        Set tokenSet = (Set)this.request.getSession().getAttribute("transactionToken");
        if (tokenSet != null && tokenFromHtml != null) {
            if (!tokenSet.contains(tokenFromHtml)) {
                SplibExceptionHandlerData info = (SplibExceptionHandlerData)this.request.getAttribute("ecuacion.spring.mvc.infoForErrorHandling");
                info.setNextPageOnError(null);
                String msgId = "jp.ecuacion.splib.web.tool.common.message.tokenInvalidate";
                throw new CustomizedValidationAppException(msgId);
            }
            tokenSet.remove(tokenFromHtml);
        }
        if (needsValidationCheck) {
            boolean hasNotEmptyError = false;
            if (form instanceof SplibEditForm) {
                SplibEditForm f = (SplibEditForm)form;
                hasNotEmptyError = f.hasNotEmptyError();
            }
            if (hasNotEmptyError || result != null && result.hasErrors()) {
                throw new InputValidationException(form);
            }
        }
    }
}

