package jp.ecuacion.splib.web.enums;

/**
 * ログイン状態を指定。
 * public=loginなし、account=一般ユーザログイン、admin=管理者／サービス提供側のログイン、を想定。
 * <p>
 * 以下の用途で使用。
 * <ul>
 *   <li>URLの一部に入る。https://domain/contextPath/xxx/.... のxxx部分。
 *   <li>navBarの種類を指定。loginStateにより全く異なるメニューのnavBarを表示することが可能。
 * </ul>
 * </p>
 */
public enum LoginStateEnum {
  
  /** 
   * loginStateと言う意味では、本当はpublicよりnoneなどの方がわかりやすいのだが、
   * この名称がそのままhttps://domain/contextPath/xxx/....のxxx部分に載り、urlにnoneがあるのも違和感あるのでpublicとした。
   */
  PUBLIC("public"), 
  
  ACCOUNT("account"), 
  
  ADMIN("admin"),
  
  ECUACION_PUBLIC("ecuacion-public");

  private String code;
  
  private LoginStateEnum(String code) { 
    this.code = code;
  }
  
  public String getCode() {
    return code;
  }
}
