/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jp.ecuacion.lib.core.entity.AbstractEntity;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.splib.core.form.record.SplibRecord;
import jp.ecuacion.splib.web.advice.SplibExceptionHandlerData;
import jp.ecuacion.splib.web.controller.internal.SplibBaseWithRecordController;
import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.form.SplibEditForm;
import jp.ecuacion.splib.web.form.SplibForm;
import jp.ecuacion.splib.web.form.SplibListForm;
import jp.ecuacion.splib.web.form.SplibSearchConditionForm;
import jp.ecuacion.splib.web.service.SplibService;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public abstract class SplibListEditController<S extends SplibSearchConditionForm, E extends SplibEditForm>
extends SplibBaseWithRecordController {
    private String editSuccessRedirectPath;

    protected abstract S getNewSearchConditionForm();

    public abstract <T extends AbstractEntity> SplibService<T> getService();

    public SplibListEditController(LoginStateEnum loginState, String functionName, String rootRecordName) {
        super(loginState, functionName, rootRecordName);
    }

    public SplibListEditController(LoginStateEnum loginState, String functionName) {
        super(loginState, functionName, functionName);
    }

    protected void setEditSuccessRedirectPath(String path) {
        this.editSuccessRedirectPath = path;
    }

    @GetMapping(value={"search"})
    public String search(Model model, S f) throws MultipleAppException {
        S searchForm = this.getProperSearchConditionForm(model, f);
        SplibService service = this.getService();
        service.setEntityManager(this.dbAccessManager.getEntityManager());
        SplibListForm<SplibRecord> listForm = this.getService().getListForm((SplibSearchConditionForm)searchForm);
        listForm.setMenuName(((SplibForm)searchForm).getMenuName());
        model.addAttribute(this.functionName + "ListForm", listForm);
        return this.functionName + "List";
    }

    public String search(Model model, String menuName) throws MultipleAppException {
        S form = this.getNewSearchConditionForm();
        ((SplibForm)form).setMenuName(menuName);
        return this.search(model, form);
    }

    protected S getProperSearchConditionForm(Model model, S f) {
        String formName = this.functionName + "SearchConditionForm";
        String key = this.getSessionKey(formName, f);
        if (f != null) {
            if (((SplibSearchConditionForm)f).isRequestFromSearchForm()) {
                this.request.getSession().setAttribute(key, f);
            }
            if (this.request.getSession().getAttribute(key) == null) {
                this.request.getSession().setAttribute(key, f);
            }
        } else if (this.request.getSession().getAttribute(formName) == null) {
            throw new RuntimeException("f == null cannot be occurred.");
        }
        SplibSearchConditionForm formUsedForSearch = (SplibSearchConditionForm)this.request.getSession().getAttribute(this.getSessionKey(formName, f));
        model.addAttribute(formName, (Object)formUsedForSearch);
        return (S)formUsedForSearch;
    }

    private String getSessionKey(String formName, S f) {
        return formName + (String)(f == null || ((SplibForm)f).getMenuName() == null || ((SplibForm)f).getMenuName().equals("") ? "" : "." + ((SplibForm)f).getMenuName());
    }

    @GetMapping(value={"search"}, params={"conditionClear"})
    public String searchConditionClear(Model model, S f) throws MultipleAppException {
        String formName = this.functionName + "SearchConditionForm";
        String sessionKey = formName + (String)(((SplibForm)f).getMenuName() == null || ((SplibForm)f).getMenuName().equals("") ? "" : "." + ((SplibForm)f).getMenuName());
        this.request.getSession().setAttribute(sessionKey, null);
        return "redirect:/" + this.loginState.getCode() + "/" + this.functionName + "/search?" + this.getUrlParams(((SplibForm)f).getMenuName(), false);
    }

    @GetMapping(value={"list"}, params={"showInsertForm"})
    public String showInsertForm(Model model, E f) throws AppException {
        this.prepareWithMovingToListOnError((SplibForm)f, model);
        SplibEditForm form = this.getService().getInsertForm((SplibEditForm)f);
        form.setIsInsert(true);
        form.setMenuName(((SplibForm)f).getMenuName());
        model.addAttribute(this.functionName + "EditForm", (Object)form);
        return this.functionName + "Edit";
    }

    @GetMapping(value={"list"}, params={"showUpdateForm"})
    public String showUpdateForm(Model model, E f) throws Exception {
        this.prepareWithMovingToListOnError((SplibForm)f, model);
        SplibEditForm form = this.getService().getUpdateForm((SplibEditForm)f);
        form.setIsInsert(false);
        form.setMenuName(((SplibForm)f).getMenuName());
        model.addAttribute(this.functionName + "EditForm", (Object)form);
        return this.functionName + "Edit";
    }

    @GetMapping(value={"list"}, params={"delete"})
    public String delete(Model model, E f, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepareWithMovingToListOnError((SplibForm)f, model);
        this.getService().delete((SplibEditForm)f, loginUser);
        return "redirect:/" + this.loginState.getCode() + "/" + this.functionName + "/search?success" + this.getUrlParams(((SplibForm)f).getMenuName(), true);
    }

    protected String getUrlParams(String menuName, boolean needsAmpersand) {
        Object additionalString = "";
        if (menuName != null && !menuName.equals("")) {
            additionalString = (needsAmpersand ? "&" : "") + "menuName=" + menuName;
        }
        return additionalString;
    }

    @PostMapping(value={"edit"})
    public String edit(@Validated E f, BindingResult result, Model model, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepare((SplibForm)f, model, this.functionName + "Edit", result, true);
        this.getService().edit((SplibEditForm)f, loginUser);
        return "redirect:" + (String)(this.editSuccessRedirectPath == null ? "/" + this.loginState.getCode() + "/" + this.functionName + "/search?success" : this.editSuccessRedirectPath) + this.getUrlParams(((SplibForm)f).getMenuName(), true);
    }

    @PostMapping(value={"edit"}, params={"back"})
    public String back(@Validated E f, BindingResult result, Model model) {
        return "redirect:/" + this.loginState.getCode() + "/" + this.functionName + "/search?" + this.getUrlParams(((SplibForm)f).getMenuName(), false);
    }

    @PostMapping(value={"edit"}, params={"updateDropDown=true"})
    public String updateOptions(E f, Model model) throws Exception {
        this.prepare((SplibForm)f, model, this.functionName + "Edit", null, false);
        model.addAttribute(this.functionName + "EditForm", f);
        return this.functionName + "Edit";
    }

    protected void prepare(SplibForm form, Model model, String nextPageOnError, BindingResult result, boolean needsValidationCheck) throws InputValidationException, AppException {
        SplibExceptionHandlerData info = new SplibExceptionHandlerData((SplibListEditController<? extends SplibSearchConditionForm, ? extends SplibEditForm>)this, form, nextPageOnError);
        this.request.setAttribute("ecuacion.spring.mvc.infoForErrorHandling", (Object)info);
        if (form instanceof SplibEditForm) {
            this.prepareEditForm((SplibEditForm)form);
        }
        this.commonProc(form, model, result, needsValidationCheck);
    }

    protected void prepare(SplibForm form, Model model, String nextPageOnError) throws InputValidationException, AppException {
        this.prepare(form, model, nextPageOnError, null, false);
    }

    protected void prepareEditForm(SplibEditForm form) {
        this.getService().prepareEditForm(form);
    }

    protected void prepareWithMovingToListOnError(BindingResult result, SplibForm form, Model model) throws InputValidationException, AppException {
        SplibExceptionHandlerData info = new SplibExceptionHandlerData(this, form);
        this.request.setAttribute("ecuacion.spring.mvc.infoForErrorHandling", (Object)info);
        this.commonProc(form, model, result, false);
    }

    protected void prepareWithMovingToListOnError(SplibForm form, Model model) throws InputValidationException, AppException {
        this.prepareWithMovingToListOnError(null, form, model);
    }
}

