package jp.ecuacion.splib.web.controller;

import jp.ecuacion.splib.web.enums.LoginStateEnum;
import jp.ecuacion.splib.web.form.ConfigForm;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope("prototype")
@RequestMapping("/public/ecuacion")
public class ConfigController extends SplibBaseController {
  
  public ConfigController() {
    super(LoginStateEnum.PUBLIC, "ecuacion");
  }

  @GetMapping("config")
  public String config(Model model) {
    ConfigForm form = new ConfigForm();
    model.addAttribute("configForm", form);
    return "config";
  }
}
